package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.helper.SkinHelper;


public class AdminTextAdapter extends BaseMsgAdapter {

    public AdminTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return R.layout.aihelp_ada_msg_admin;
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_ADMIN_TEXT;
    }

    @Override
    public void convert(ViewHolder holder, ConversationMsg s, int position) {

        LinearLayout llContainer = holder.getView(R.id.aihelp_admin_message_container);
        if (isCurrentRtl) {
            llContainer.setBackgroundResource(R.drawable.aihelp_bg_msg_admin_ar);
        }

        SkinHelper.updateBackground(SkinHelper.SKIN_ADMIN_MSG, llContainer);
        llContainer.removeAllViews();

        boolean isElvaBot = s instanceof ElvaBotMsg;
        holder.setVisible(R.id.aihelp_iv_portrait, Const.TOGGLE_SHOW_PORTRAIT);
        holder.setImageResource(R.id.aihelp_iv_portrait, isElvaBot ? R.drawable.aihelp_svg_portrait_robot : R.drawable.aihelp_svg_portrait_admin);
        SkinHelper.updateIcon(isElvaBot ? SkinHelper.SKIN_PORTRAIT_BOT : SkinHelper.SKIN_PORTRAIT_ADMIN, holder.getView(R.id.aihelp_iv_portrait));

        if (isElvaBot) {
            convertElvaBotTextMsg(llContainer, (ElvaBotMsg) s);
        } else {
            convertSupportTextMsg(holder, llContainer, s);
        }

    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, ConversationMsg msg) {
        holder.setVisible(R.id.aihelp_tv_nickname, Const.TOGGLE_SHOW_NICKNAME && !TextUtils.isEmpty(msg.getNickname()));
        holder.setText(R.id.aihelp_tv_nickname, msg.getNickname());
        container.addView(getMsg(msg.getMsgContent()));
    }

    private void convertElvaBotTextMsg(ViewGroup container, ElvaBotMsg botMsg) {
        container.addView(getMsg(botMsg.getBotMsg()));
        if (botMsg.isHasUrl()) {
            container.addView(getUrl(botMsg.getBotUrl(), mWrapper));
        }
        if (botMsg.isHasFormUrl()) {
            container.addView(getFormUrl(botMsg, mWrapper));
        }
        if (botMsg.isHasAction()) {
            for (int i = 0; i < botMsg.getActions().size(); i++) {
                container.addView(getAction(i + 1, botMsg.getActions().get(i), mWrapper));
            }
        }
    }

}
