package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;

import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.helper.SkinHelper;
import net.aihelp.ui.widget.AIHelpLoadingImageView;


public class AdminImageAdapter extends BaseMsgAdapter {

    public AdminImageAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return R.layout.aihelp_ada_msg_admin_image;
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_ADMIN_IMAGE;
    }

    @Override
    public void convert(ViewHolder holder, final ConversationMsg conversationMsg, final int position) {

        holder.setVisible(R.id.aihelp_iv_portrait, Const.TOGGLE_SHOW_PORTRAIT);
        SkinHelper.updateIcon(SkinHelper.SKIN_PORTRAIT_ADMIN, holder.getView(R.id.aihelp_iv_portrait));

        holder.setVisible(R.id.aihelp_tv_nickname, Const.TOGGLE_SHOW_NICKNAME && !TextUtils.isEmpty(conversationMsg.getNickname()));
        holder.setText(R.id.aihelp_tv_nickname, conversationMsg.getNickname());

        final AIHelpLoadingImageView imageView = holder.getView(R.id.aihelp_iv_holder);
        imageView.loadIntoImageView(mContext, conversationMsg);

        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (imageView.isLoading()) return;
                ImageViewer imageViewer = ImageViewer.getDefault(mContext);
                imageViewer.updateImageResource(conversationMsg.getMsgContent());
                imageViewer.show();
            }
        });

    }

}
