package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.helper.SkinHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.utils.FastClickValidator;


public class AdminFaqAdapter extends BaseMsgAdapter {

    public AdminFaqAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return R.layout.aihelp_ada_msg_faq;
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_ADMIN_FAQ;
    }

    @Override
    public void convert(final ViewHolder holder, ConversationMsg s, int position) {

        if (s instanceof ElvaBotMsg) {

            final ElvaBotMsg botMsg = (ElvaBotMsg) s;
            String faqContentId = "";
            if (botMsg.isHasUrl()) {
                int index = TextUtils.indexOf(botMsg.getBotUrl().getUrlAddress(), "?id=");
                if (index != -1) {
                    faqContentId = botMsg.getBotUrl().getUrlAddress().substring(index + "?id=".length());
                }
            }
            final String finalFaqContentId = faqContentId;

            LinearLayout llContainer = holder.getView(R.id.aihelp_admin_message_container);
            SkinHelper.updateBackground(SkinHelper.SKIN_ADMIN_MSG, llContainer);
            llContainer.removeAllViews();

            llContainer.addView(getFAQLayout(botMsg, mWrapper));

            holder.setVisible(R.id.aihelp_iv_portrait, Const.TOGGLE_SHOW_PORTRAIT);
            SkinHelper.updateIcon(SkinHelper.SKIN_PORTRAIT_BOT, holder.getView(R.id.aihelp_iv_portrait));

            holder.setVisible(R.id.aihelp_rl_helpful, Const.TOGGLE_EVALUATE_BOT_FAQ &&
                    botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_NORMAL);

            holder.setOnClickListener(R.id.aihelp_iv_faq_unhelpful, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mWrapper != null && FastClickValidator.validate()) {
                        mWrapper.onFaqHelpfulClicked(false, botMsg.getTimeStamp());
                    }
                }
            });

            holder.setOnClickListener(R.id.aihelp_iv_faq_helpful, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mWrapper != null && FastClickValidator.validate()) {
                        mWrapper.onFaqHelpfulClicked(true, botMsg.getTimeStamp());
                    }
                }
            });

            holder.setVisible(R.id.aihelp_ll_feedback, Const.TOGGLE_EVALUATE_BOT_FAQ &&
                    botMsg.getMsgStatus() != ConversationMsg.STATUS_FAQ_NORMAL);

            TextView tvAdvice = holder.getView(R.id.aihelp_tv_advice);
            tvAdvice.setEnabled(true);
            tvAdvice.setTextColor(mContext.getResources().getColor(R.color.aihelp_color_main));
            holder.setVisible(R.id.aihelp_tv_advice, botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_UNHELPFUL);


            holder.setOnClickListener(R.id.aihelp_tv_advice, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (FastClickValidator.validate()) {
                        if (mWrapper != null) {
                            mWrapper.onFaqFeedbackClicked((TextView) holder.getView(R.id.aihelp_tv_advice), botMsg, finalFaqContentId);
                        }
                    }
                }
            });

            SkinHelper.updateIcon(SkinHelper.SKIN_FAQ_UNHELPFUL, holder.getView(R.id.aihelp_iv_faq_unhelpful));
            SkinHelper.updateIcon(SkinHelper.SKIN_FAQ_HELPFUL, holder.getView(R.id.aihelp_iv_faq_helpful));

        }

    }

}
