package net.aihelp.ui.adapter;

import android.os.Bundle;

import net.aihelp.common.IntentValues;
import net.aihelp.db.op.pojo.OperateSection;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.op.OperateListFragment;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager2.adapter.FragmentStateAdapter;


public class OperateViewPagerAdapter extends FragmentStateAdapter {

    private Bundle bundle;
    private List<OperateSection> sectionList;
    public OperateViewPagerAdapter(@NonNull Fragment fragment, Bundle bundle,
                                   List<OperateSection> fragments) {
        super(fragment);
        this.bundle = bundle;
        this.sectionList = fragments;
    }

    public OperateViewPagerAdapter(@NonNull FragmentActivity fragmentActivity, Bundle bundle, List<OperateSection> sectionList) {
        super(fragmentActivity);
        this.bundle = bundle;
        this.sectionList = sectionList;
    }

    @NonNull
    @Override
    public Fragment createFragment(int position) {
        if (position == getItemCount() - 1) {
            boolean humanEmbedded = bundle.getBoolean(IntentValues.HUMAN_EMBEDDED_IN_OPERATION);
//            bundle.putBoolean(IntentValues.BOT_EMBEDDED_IN_OPERATION, !humanSupport);
//            bundle.putBoolean(IntentValues.HUMAN_EMBEDDED_IN_OPERATION, humanSupport);
            return humanEmbedded ? ConversationFragment.newInstance(bundle) : ElvaBotFragment.newInstance(bundle);
        }
        bundle.putString(IntentValues.OPERATE_SECTION_ID, sectionList.get(position).getSecId());
        return OperateListFragment.getInstance(bundle);
    }

    @Override
    public int getItemCount() {
        return sectionList == null ? 0 : sectionList.size() + 1;
    }


}