package net.aihelp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.core.ui.adapter.CommonAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.db.op.pojo.OperateFaq;


public class OperateListAdapter extends CommonAdapter<OperateFaq> {

    private OnOperationFaqClickedListener mListener;

    public OperateListAdapter(Context context, OnOperationFaqClickedListener listener) {
        super(context);
        this.mListener = listener;
    }

    @Override
    protected int itemLayoutId() {
        return R.layout.aihelp_ada_item_op_list;
    }

    @Override
    protected void convert(ViewHolder holder, final OperateFaq faq, int position) {
        Picasso.get().load(faq.getFaqImageUrl()).into((ImageView) holder.getView(R.id.aihelp_iv_portrait));
        holder.setText(R.id.aihelp_tv_op_title, faq.getFaqTitle());
        TextView tvTitle = holder.getView(R.id.aihelp_tv_op_title);
        tvTitle.setSelected(true);

        holder.setText(R.id.aihelp_tv_time, faq.getFaqUpdateDate());

        holder.getConvertView().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null) {
                    mListener.onOperationFaqClicked(faq.getFaqId());
                }
            }
        });

    }

    public interface OnOperationFaqClickedListener {
        void onOperationFaqClicked(String faqId);
    }

}
