package net.aihelp.ui.adapter;

import android.content.Context;
import android.widget.TextView;

import net.aihelp.core.ui.adapter.MultiItemTypeAdapter;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.ui.adapter.cs.admin.AdminRichTextAdapter;
import net.aihelp.ui.adapter.cs.hint.TimeMsgAdapter;
import net.aihelp.ui.adapter.cs.admin.AdminFaqAdapter;
import net.aihelp.ui.adapter.cs.admin.AdminImageAdapter;
import net.aihelp.ui.adapter.cs.admin.AdminTextAdapter;
import net.aihelp.ui.adapter.cs.user.UserImageAdapter;
import net.aihelp.ui.adapter.cs.user.UserTextAdapter;
import net.aihelp.ui.adapter.cs.user.UserVideoAdapter;

import java.util.List;


public class MessageListAdapter extends MultiItemTypeAdapter<ConversationMsg> {

    private final AdminTextAdapter adminAdapter;
    private final AdminFaqAdapter adminFaqAdapter;
    private final AdminRichTextAdapter adminRichTextAdapter;
    private final UserTextAdapter userAdapter;
    private final UserImageAdapter userImageAdapter;
    private final UserVideoAdapter userVideoAdapter;

    public MessageListAdapter(Context mContext) {
        super(mContext);

        adminAdapter = new AdminTextAdapter(mContext);
        addItemViewDelegate(adminAdapter);

        adminRichTextAdapter = new AdminRichTextAdapter(mContext);
        addItemViewDelegate(adminRichTextAdapter);

        adminFaqAdapter = new AdminFaqAdapter(mContext);
        addItemViewDelegate(adminFaqAdapter);

        userAdapter = new UserTextAdapter(mContext);
        addItemViewDelegate(userAdapter);

        addItemViewDelegate(new TimeMsgAdapter(mContext));

        userImageAdapter = new UserImageAdapter(mContext);
        addItemViewDelegate(userImageAdapter);

        userVideoAdapter = new UserVideoAdapter(mContext);
        addItemViewDelegate(userVideoAdapter);

        addItemViewDelegate(new AdminImageAdapter(mContext));
//        addItemViewDelegate(new ADA_AdminVideo(mContext));

    }

    public void insertHistoryConversation(List<ConversationMsg> msgList) {
        mDatas.addAll(0, msgList);
        notifyDataSetChanged();
    }

    private interface OnTextClickedListener{
        void onActionClicked(String action);

        void onUrlClicked(String url);

        void onFormUrlClicked(long timeStamp, String formUrl);

        void onFaqClicked(ElvaBotMsg faqUrl);

        void onFaqHelpfulClicked(boolean helpful, long timeStamp);

        void onFaqFeedbackClicked(TextView view, ElvaBotMsg botMsg, String faqId);

        void onRetrySendingMessage(int position, ConversationMsg msgContent);

        void onImageViewPicked(int position, String url, int viewId);

    }

    public void setOnClickedListener(OnClickedListenerWrapper mListener) {
        if (adminAdapter != null) {
            adminAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (adminFaqAdapter != null) {
            adminFaqAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (userAdapter != null) {
            userAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (userImageAdapter != null) {
            userImageAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (userVideoAdapter != null) {
            userVideoAdapter.setOnClickedListenerWrapper(mListener);
        }

    }

    public static class OnClickedListenerWrapper implements OnTextClickedListener {

        @Override
        public void onActionClicked(String action) {

        }

        @Override
        public void onUrlClicked(String url) {

        }

        @Override
        public void onFormUrlClicked(long timeStamp, String formUrl) {

        }

        @Override
        public void onFaqClicked(ElvaBotMsg botMsg) {

        }

        @Override
        public void onFaqHelpfulClicked(boolean helpful, long timeStamp) {

        }

        @Override
        public void onFaqFeedbackClicked(TextView view, ElvaBotMsg botMsg, String faqId) {

        }

        @Override
        public void onRetrySendingMessage(int position, ConversationMsg msg) {

        }

        @Override
        public void onImageViewPicked(int position, String url, int viewId) {

        }

    }


}
