package net.aihelp.ui.adapter;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.core.ui.adapter.CommonAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.db.faq.pojo.DisplayFaq;
import net.aihelp.utils.Styles;


public class FaqListAdapter extends CommonAdapter<DisplayFaq> {

    public FaqListAdapter(Context context) {
        super(context);
    }

    @Override
    protected int itemLayoutId() {
        return R.layout.aihelp_ada_faq_list;
    }

    @Override
    protected void convert(ViewHolder holder, final DisplayFaq faq, int position) {

        switch (faq.getFaqType()) {
            case DisplayFaq.FAQ_DISPLAY_SECTION:
                convertRootListView(holder, faq);
                break;
            case DisplayFaq.FAQ_DISPLAY_SUB_SECTION:
            case DisplayFaq.FAQ_DISPLAY_QUESTION_LIST:
                convertSubListView(holder, faq);
                break;
            case DisplayFaq.FAQ_DISPLAY_SEARCH:
                convertSearchMatchingFaqTitles(holder, faq);
                break;
        }

        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null) {
                    switch (faq.getFaqType()) {
                        case DisplayFaq.FAQ_DISPLAY_SECTION:
                            mListener.onIntentFromRootSectionList(faq.isHasSubSection(), faq.getId());
                            break;
                        case DisplayFaq.FAQ_DISPLAY_SUB_SECTION:
                            mListener.onIntentFromSubSectionList(faq.getId());
                            break;
                        case DisplayFaq.FAQ_DISPLAY_QUESTION_LIST:
                        case DisplayFaq.FAQ_DISPLAY_SEARCH:
                            mListener.onIntentToQuestionContent(faq.getId(), faq.getContentId(), faq.getMatch());
                            break;
                    }
                }
            }
        });

    }

    private void convertRootListView(ViewHolder holder, final DisplayFaq faq) {
        TextView tvTitle = holder.getView(R.id.aihelp_tv_title);
        tvTitle.setText(faq.getTitle());
        tvTitle.setTextColor(mContext.getResources().getColor(R.color.aihelp_color_text_title));
        tvTitle.setTextSize(17);
    }

    private void convertSubListView(ViewHolder holder, final DisplayFaq faq) {
        TextView tvTitle = holder.getView(R.id.aihelp_tv_title);
        tvTitle.setText(faq.getTitle());
        tvTitle.setTextColor(mContext.getResources().getColor(R.color.aihelp_color_text_content));
        tvTitle.setTextSize(15);
    }

    private void convertSearchMatchingFaqTitles(ViewHolder holder, final DisplayFaq faq) {
        try {
            TextView tvTitle = holder.getView(R.id.aihelp_tv_title);
            tvTitle.setTextColor(mContext.getResources().getColor(R.color.aihelp_color_text_title));
            tvTitle.setTextSize(15);

            if (!TextUtils.isEmpty(faq.getMatch())) {
                String matchedWords = faq.getMatch().toLowerCase();
                String title = faq.getTitle().toLowerCase();
                int highlightColor = Styles.getColor(mContext, R.color.aihelp_color_main);
                Spannable spannedTitle = new SpannableString(faq.getTitle());
                for (int index = TextUtils.indexOf(title, matchedWords, 0); index >= 0; index = TextUtils.indexOf(title, matchedWords, index + matchedWords.length())) {
                    spannedTitle.setSpan(new ForegroundColorSpan(highlightColor), index, Math.min(index + matchedWords.length(), title.length()), 33);
                }
                tvTitle.setText(spannedTitle);
            } else {
                tvTitle.setText(faq.getTitle());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private interface OnSectionSelectedListener {

        void onIntentFromRootSectionList(boolean isHasSubSection, String secId);

        void onIntentFromSubSectionList(String subSectionId);

        void onIntentToQuestionContent(String faqId, String faqContentId, String match);
    }

    private OnSectionSelectedListener mListener;

    public void setOnSectionSelectedListener(OnSectionSelectedListener mListener) {
        this.mListener = mListener;
    }

    public static class FaqSelectedListenerWrapper implements OnSectionSelectedListener {

        @Override
        public void onIntentFromRootSectionList(boolean isHasSubSection, String secId) {

        }

        @Override
        public void onIntentFromSubSectionList(String subSectionId) {

        }

        @Override
        public void onIntentToQuestionContent(String faqId, String faqContentId, String match) {

        }
    }


}
