package net.aihelp.ui.adapter;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.core.ui.adapter.CommonAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.db.faq.pojo.DisplayFaq;
import net.aihelp.utils.Styles;


public class FaqAlertAdapter extends CommonAdapter<DisplayFaq> {

    private View.OnClickListener mListener;
    public FaqAlertAdapter(Context context, View.OnClickListener onClickListener) {
        super(context);
        mListener = onClickListener;
    }

    @Override
    protected int itemLayoutId() {
        return R.layout.aihelp_ada_faq_alert;
    }

    @Override
    protected void convert(ViewHolder holder, DisplayFaq faq, int position) {

        TextView textView = holder.getView(R.id.aihelp_tv_faq_title);

        if (!TextUtils.isEmpty(faq.getMatch())) {
            String matchedWords = faq.getMatch().toLowerCase();
            String title = faq.getTitle().toLowerCase();
            int highlightColor = Styles.getColor(mContext, R.color.aihelp_color_main);
            Spannable spannedTitle = new SpannableString(faq.getTitle());
            for (int index = TextUtils.indexOf(title, matchedWords, 0); index >= 0; index = TextUtils.indexOf(title, matchedWords, index + matchedWords.length())) {
                spannedTitle.setSpan(new ForegroundColorSpan(highlightColor), index, index + matchedWords.length(), 33);
            }
            textView.setText(spannedTitle);
        } else {
            textView.setText(faq.getTitle());
        }

        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null) {
                    mListener.onClick(v);
                }
            }
        });
    }

}
