package net.aihelp.ui.adapter;

import android.content.Context;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.data.model.EvaluationEntity;
import net.aihelp.ui.widget.AIHelpBottomSheetListView;
import net.aihelp.utils.SoftInputUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;
import java.util.regex.Pattern;


public class EvaluateSuggestAdapter extends BaseAdapter {

    private Context mContext;
    private List<EvaluationEntity.DetailBean> configList;

    private AIHelpBottomSheetListView lvList;

    public EvaluateSuggestAdapter(Context context) {
        mContext = context;
    }

    public EvaluateSuggestAdapter(Context mContext, AIHelpBottomSheetListView lvList,
                                  List<EvaluationEntity.DetailBean> list) {
        this.mContext = mContext;
        this.lvList = lvList;
        this.configList = list;
        for (EvaluationEntity.DetailBean detailBean : list) {
            detailBean.setSelected(false);
        }
    }

    public void setConfigList(List<EvaluationEntity.DetailBean> configList) {
        this.configList = configList;
    }

    @Override
    public int getCount() {
        return configList.size();
    }

    @Override
    public EvaluationEntity.DetailBean getItem(int position) {
        return configList.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = View.inflate(mContext, R.layout.aihelp_ada_evaluate_suggest, null);
            holder = new ViewHolder(convertView);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        final EvaluationEntity.DetailBean configBean = configList.get(position);
        holder.tvName.setText(configBean.getMsg());

        holder.vSelected.setVisibility(configBean.isSelected() ? View.VISIBLE : View.GONE);

        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isKeyboardShown()) SoftInputUtil.hideSoftInput(mContext, lvList);
                configBean.setSelected(!configBean.isSelected());
                notifyDataSetChanged();
                if (mListener != null) {
                    mListener.onSelectChanged();
                }
            }
        });

        if (lvList != null) {
            convertView.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == MotionEvent.ACTION_DOWN) {
                        lvList.setCoordinatorDisallow();
                    }
                    return false;
                }
            });
        }

        return convertView;
    }

    private static class ViewHolder {

        private View vSelected;
        private TextView tvName;

        private ViewHolder(View convertView) {
            vSelected = convertView.findViewById(R.id.aihelp_v_selected);
            tvName = convertView.findViewById(R.id.aihelp_tv_suggest);
        }

    }

    public JSONArray getSelectedItems() {
        JSONArray jsonArray = new JSONArray();
        for (EvaluationEntity.DetailBean detailBean : configList) {
            if (detailBean.isSelected()) {
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("id", Pattern.matches("[0-9]*", detailBean.getId())
                            ? Integer.parseInt(detailBean.getId()) : 0);
                    jsonObject.put("msg", detailBean.getMsg());
                    jsonArray.put(jsonObject);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return jsonArray;
    }

    public boolean isHasSelectedItem() {
        for (EvaluationEntity.DetailBean detailBean : configList) {
            if (detailBean.isSelected()) {
                return true;
            }
        }
        return false;
    }

    public interface OnSelectChangedListener {
        void onSelectChanged();
    }

    private OnSelectChangedListener mListener;

    public void setOnSelectChangedListener(OnSelectChangedListener mListener) {
        this.mListener = mListener;
    }

    private boolean isKeyboardShown() {
        if (lvList != null) {
            View rootView = lvList.getRootView();
            final int softKeyboardHeight = 100;
            Rect r = new Rect();
            rootView.getWindowVisibleDisplayFrame(r);
            DisplayMetrics dm = rootView.getResources().getDisplayMetrics();
            int heightDiff = rootView.getBottom() - r.bottom;
            return heightDiff > softKeyboardHeight * dm.density;
        }
        return false;
    }

}
