package net.aihelp.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.R.layout;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.OperatePagerEvent;
import net.aihelp.data.event.SkinUpdateEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.faq.QuestionContentFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.faq.IFaqParentView;
import net.aihelp.ui.helper.BreakReleaseHelper;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.helper.SkinHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.helper.SupportHelper;
import net.aihelp.ui.op.OperationFragment;
import net.aihelp.ui.widget.AIHelpMsgView;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.LocalizeHelper;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.Fragment;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class SupportFragment extends BaseFragment implements View.OnClickListener, IFaqParentView {

    private SupportHelper mSupportHelper;

    private ImageView ivLoading;

    private AIHelpMsgView msgView;

    private ObjectAnimator loadingAnimator;
    private boolean isOperateInHelpPage;

    public static SupportFragment getInstance(Bundle bundle) {
        SupportFragment fraSupport = new SupportFragment();
        fraSupport.setArguments(bundle);
        return fraSupport;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (mSupportHelper == null) {
            mSupportHelper = new SupportHelper(context, getRetainedChildFragmentManager(), getArguments());
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        mSupportHelper.start();
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        if (shouldLocalizeFAQ(extras)) {
            LocalizeHelper.getLocalizeDataFromUrl(LocalizeHelper.FLAG_FAQ);
        }
    }

    private boolean shouldLocalizeFAQ(Bundle extras) {
        int supportMode = extras.getInt(IntentValues.SUPPORT_MODE, 0);
        return supportMode == IntentValues.MODE_OPERATE || supportMode == IntentValues.MODE_ELVA
                || supportMode == IntentValues.MODE_CONVERSATION;
    }

    @Override
    protected void initEventAndData(View view) {

        ivLoading = (ImageView) get(R.id.aihelp_iv_loading);
        msgView = (AIHelpMsgView) get(R.id.aihelp_msg_view);

        TextView tvTitle = (TextView) get(R.id.aihelp_tv_title);
        tvTitle.setText(Const.APP_SHOW_NAME);
        tvTitle.setOnClickListener(new BreakReleaseHelper());

        get(R.id.aihelp_iv_back).setOnClickListener(this);
        msgView.setOnClickListener(this);

        loadingAnimator = ObjectAnimator.ofFloat(ivLoading, "rotation", 0F, 360F);
        loadingAnimator.setDuration(1000);
        loadingAnimator.setInterpolator(new LinearInterpolator());
        loadingAnimator.setRepeatCount(ValueAnimator.INFINITE);

    }

    @Override
    protected int getLayout() {
        return layout.aihelp_fra_support;
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    @Override
    public void onEventComing(EventCenter event) {

        boolean isOperatePage = false;
        Fragment topMostFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
        if (topMostFragment != null) {
            isOperatePage = OperationFragment.class.getSimpleName().equals(topMostFragment.getClass().getSimpleName());
        }

        if (!isOperatePage && event instanceof SkinUpdateEvent) {
            SkinUpdateEvent skinUpdateEvent = (SkinUpdateEvent) event;
            if (skinUpdateEvent.getSupportAction() == IntentValues.SHOW_NAVIGATION_SKIN) {
                SkinHelper.updateBackground(SkinHelper.SKIN_NAVIGATION_BAR, get(R.id.aihelp_rl_skin));
                SkinHelper.updateIcon(SkinHelper.SKIN_GO_BACK, get(R.id.aihelp_iv_back));
            } else {
                get(R.id.aihelp_rl_skin).setBackgroundColor(Color.TRANSPARENT);
                ((AppCompatImageView) get(R.id.aihelp_iv_back)).setImageResource(R.drawable.aihelp_svg_ic_back);
            }
        }

        if (event instanceof OperatePagerEvent) {
            isOperateInHelpPage = ((OperatePagerEvent) event).getEvent();
        }

        if (event instanceof SupportActionEvent) {
            SupportActionEvent supportActionEvent = (SupportActionEvent) event;
            if (supportActionEvent.getCode() == IntentValues.SHOW_SUPPORT_ACTION) {
                msgView.setVisibility(View.VISIBLE);
                int supportAction = supportActionEvent.getSupportAction();
                switch (supportAction) {
                    case IntentValues.SUPPORT_ACTION_FAQ:
                        msgView.updateImageResource(supportAction, R.drawable.aihelp_svg_ic_faq);
                        break;
                    case IntentValues.SUPPORT_ACTION_MSG:
                    case IntentValues.SUPPORT_ACTION_MSG_UNREAD:
                        if (isOperatePage && !isOperateInHelpPage) return;
                        msgView.updateImageResource(supportAction, R.drawable.aihelp_svg_ic_msg_read);
                        break;
                    default:
                        msgView.setVisibility(View.GONE);
                        break;
                }
            } else {
                msgView.setVisibility(View.GONE);
            }
        }

        if (event instanceof LoadingElvaEvent) {
            if (event.getCode() == IntentValues.SHOW_CS_LOADING) {
                if (loadingAnimator.isRunning() || !shouldShowLoading(topMostFragment)) return;
                ivLoading.setVisibility(View.VISIBLE);
                loadingAnimator.start();
            } else {
                ivLoading.setVisibility(View.GONE);
                loadingAnimator.cancel();
            }
        }

        if (event instanceof PageHoppingEvent) {
            switch (event.getCode()) {
                case IntentValues.PAGE_HOPPING_CONVERSATION:
                    mSupportHelper.startConversation(getArguments(), true);
                    break;
                case IntentValues.PAGE_HOPPING_FORM:
                    mSupportHelper.onIntentToFillForm(((PageHoppingEvent) event).getEvent(), true);
                    break;
            }
        }

    }

    private boolean shouldShowLoading(Fragment topFragment) {
        if (topFragment != null) {
            String topName = topFragment.getClass().getSimpleName();
            String opName = OperationFragment.class.getSimpleName();
            String botName = ElvaBotFragment.class.getSimpleName();
            String conversationName = ConversationFragment.class.getSimpleName();
            return botName.equals(topName) || conversationName.equals(topName) || opName.equals(topName);
        }
        return false;
    }

    public boolean onBackPressed() {
        Fragment topMostFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
        if (topMostFragment == null) return false;
        String topName = topMostFragment.getClass().getSimpleName();
        if (ElvaBotFragment.class.getSimpleName().equals(topName)) {
            return ((ElvaBotFragment) (topMostFragment)).onBackPressed();
        } else if (QuestionContentFragment.class.getSimpleName().equals(topName)) {
            return ((QuestionContentFragment) (topMostFragment)).onBackPressed();
        } else if (IntentUrlFragment.class.getSimpleName().equals(topName)) {
            return ((IntentUrlFragment) (topMostFragment)).onBackPressed();
        }
        return true;
    }

    @Override
    public void onClick(View v) {

        if (FastClickValidator.validate(0.5f) && Const.isNestedFragmentOnResume) {
            if (v.getId() == R.id.aihelp_iv_back) {
                if (getActivity() != null) getActivity().onBackPressed();
            }

            if (v.getId() == R.id.aihelp_msg_view) {
                Bundle bundle = getArguments();
                if (bundle == null) bundle = new Bundle();

                Fragment topMostFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
                if (topMostFragment == null) return;
                String topName = topMostFragment.getClass().getSimpleName();
                if (OperationFragment.class.getSimpleName().equals(topName)) {
                    if (isOperateInHelpPage) {
                        mSupportHelper.startConversation(bundle, true);
                    } else {
                        mSupportHelper.onIntentToSectionRoot(bundle, true);
                        StatisticHelper.whenAllFAQSectionsVisible(true);
                    }
                } else {
                    boolean skipElva = bundle.getBoolean(IntentValues.SKIP_ELVA_IN_FAQ);
                    if (ElvaBotFragment.class.getSimpleName().equals(topName) || skipElva) {
                        if (skipElva) {
                            bundle.putInt(IntentValues.SUPPORT_MODE, IntentValues.MODE_CONVERSATION);
                        }
                        mSupportHelper.startConversation(bundle, true);
                    } else {
                        mSupportHelper.startElva(bundle, true);
                    }
                }
            }
        }

    }

    @Override
    public IFaqEventListener getFaqEventListener() {
        return mSupportHelper;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

}
