package net.aihelp.ui;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;

import net.aihelp.R.layout;
import net.aihelp.R.id;
import net.aihelp.common.Const;
import net.aihelp.core.ui.BaseActivity;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.utils.TLog;

import java.util.List;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

public class HostActivity extends BaseActivity {

    FragmentManager fragmentManager;

    @Override
    public int getLayoutId() {
        return layout.aihelp_act_host;
    }

    @SuppressLint("WrongConstant")
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Const.IS_SDK_SHOWING = true;
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED,
                WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED);
        super.onCreate(savedInstanceState);
        if (Const.sSessionOpenListener != null) {
            Const.sSessionOpenListener.onAIHelpSessionOpened();
        }
    }

    @Override
    public void initView() {
        fragmentManager = getSupportFragmentManager();
        Bundle bundle = getIntent().getExtras();
        if (bundle == null) bundle = new Bundle();
        FragmentTransaction fraTransaction = fragmentManager.beginTransaction();
        fraTransaction.add(id.aihelp_root_container, SupportFragment.getInstance(bundle));
        fraTransaction.commit();
    }

    @JavascriptInterface
    public void finishFormPage() {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                onBackPressed();
            }
        });
    }

    public void onBackPressed() {
        List<Fragment> fragments = fragmentManager.getFragments();

        for (Fragment fragment : fragments) {
            if (fragment != null && fragment.isVisible() && fragment instanceof SupportFragment) {
                if (((SupportFragment) fragment).onBackPressed()) {
                    FragmentManager childFragmentManager = fragment.getChildFragmentManager();
                    if (childFragmentManager.getBackStackEntryCount() > 0) {
                        childFragmentManager.popBackStack();
                        return;
                    }
                } else {
                    return;
                }
            }
        }

        super.onBackPressed();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public boolean isApplyPendingTransition() {
        return true;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Const.IS_SDK_SHOWING = false;
        if (Const.sSessionCloseListener != null) {
            Const.sSessionCloseListener.onAIHelpSessionClosed();
        }
    }
}
