package net.aihelp.db.util;

import android.content.ContentValues;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.db.bot.tables.ElvaBotTable;
import net.aihelp.db.faq.tables.FaqTable;
import net.aihelp.db.faq.tables.SectionTable;
import net.aihelp.db.faq.tables.SubSectionTable;
import net.aihelp.db.op.tables.OperateFaqTable;
import net.aihelp.db.op.tables.OperateSectionTable;
import net.aihelp.utils.Styles;

import org.json.JSONObject;

public class ContentValuesUtil {

    /**
     * 有子分类的情况:
     * 1、sectionId、sectionName、orderNo 为子分类字段
     * 2、sectionBId、sectionBName、sectionBOrderNo 为父分类字段
     * <p>
     * 无子分类的情况时:
     * 1、sectionId、sectionName、orderNo 即为分类字段
     * 2、sectionBId、sectionBName、sectionBOrderNo 为空/默认值，不予考虑
     */
    public static ContentValues getSectionValue(JSONObject section, boolean hasSubSection) {
        ContentValues values = new ContentValues();

        try {
            String sectionId = section.optString("sectionId");
            String sectionName = section.optString("sectionName");
            String sectionOrderNo = section.optString("orderNo");
            String sectionBId = section.optString("sectionBId");
            String sectionBName = section.optString("sectionBName");
            String sectionBOrderNo = section.optString("sectionBOrderNo");

            values.put(SectionTable.Columns.SECTION_ID, hasSubSection ? sectionBId : sectionId);
            values.put(SectionTable.Columns.SECTION_TITLE, hasSubSection ? sectionBName : sectionName);
            values.put(SectionTable.Columns.SECTION_ORDER, hasSubSection ? Integer.parseInt(sectionBOrderNo) : Integer.parseInt(sectionOrderNo));
            values.put(SectionTable.Columns.HAS_SUB_SECTION, hasSubSection ? "YES" : "NO");
            values.put(SectionTable.Columns.FAQ_FILE_NAME, Const.FAQ_FILE);
//        values.put(SectionTable.Columns.SDK_HOST_ID, Const.APP_ID);
//        values.put(SectionTable.Columns.SDK_LANGUAGE, Const.TARGET_LAN);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return values;
    }

    /**
     * 在有子分类的情况下：
     * 1、sectionId、sectionName、orderNo 为子分类字段
     * 2、sectionBId、sectionBName、sectionBOrderNo 为父分类字段
     */
    public static ContentValues getSubSectionValue(JSONObject section) {
        ContentValues values = new ContentValues();

        try {
            String sectionId = section.optString("sectionId");
            String sectionName = section.optString("sectionName");
            String sectionOrderNo = section.optString("orderNo");
            String sectionBId = section.optString("sectionBId");

            values.put(SubSectionTable.Columns.SECTION_ID, sectionBId);
            values.put(SubSectionTable.Columns.SUB_ID, sectionId);
            values.put(SubSectionTable.Columns.SUB_TITLE, sectionName);
            values.put(SubSectionTable.Columns.SUB_ORDER, Integer.parseInt(sectionOrderNo));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    /**
     * 1、kmMainid，后台主键 ID，不同语言的同一条 FAQ 此 ID 值相同
     * 2、kmContentId，此 ID 用于区分同一条 FAQ 的不同语言版本
     * 3、faqId，改版后前端显示的 FAQ ID，显示规则是 [1, 当前应用的 FAQ 总条数]
     * 不同应用的 faqId 有可能相同
     */
    public static ContentValues getFaqContentValues(String sectionId, JSONObject faq) {
        ContentValues values = new ContentValues();
        try {
            values.put(FaqTable.Columns.FAQ_MAIN_ID, faq.optString("kmMainid"));
            values.put(FaqTable.Columns.FAQ_DISPLAY_ID, faq.optString("faqId"));
            values.put(FaqTable.Columns.FAQ_CONTENT_ID, faq.optString("kmContentId"));
            values.put(FaqTable.Columns.SECTION_ID, sectionId);
            values.put(FaqTable.Columns.FAQ_TITLE, faq.optString("question"));
            values.put(FaqTable.Columns.FAQ_CONTENT, faq.optString("content"));
            values.put(FaqTable.Columns.FAQ_CONTENT_NO_HTML, Styles.getNoTemplateFaqContent(faq.optString("content")));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public static ContentValues getElvaBotContentValues(long timeStamp, String rawResponse) {
        ContentValues values = new ContentValues();
        values.put(ElvaBotTable.Columns.UID, UserProfile.USER_ID);
        values.put(ElvaBotTable.Columns.APP_ID, Const.APP_ID);
        values.put(ElvaBotTable.Columns.APP_SERVER, API.HOST_URL);
        values.put(ElvaBotTable.Columns.TIME_STAMP, timeStamp);
        values.put(ElvaBotTable.Columns.RAW_RESPONSE, rawResponse);
        return values;
    }

    public static ContentValues getOperateSectionValue(JSONObject section) {
        ContentValues values = new ContentValues();
        try {
            values.put(OperateSectionTable.Columns.SECTION_ID, section.optString("sectionId"));
            values.put(OperateSectionTable.Columns.SECTION_TITLE, section.optString("sectionName"));
            values.put(OperateSectionTable.Columns.SECTION_ORDER, section.optString("orderNo"));
            values.put(OperateSectionTable.Columns.OPERATE_FILE_NAME, Const.OP_FILE);
        } catch (Exception e) {
            e.printStackTrace();
        }
//        values.put(SectionTable.Columns.SDK_HOST_ID, Const.APP_ID);
//        values.put(SectionTable.Columns.SDK_LANGUAGE, Const.TARGET_LAN);
        return values;
    }

    public static ContentValues getOperateFaqValue(String sectionId, JSONObject faq) {
        ContentValues values = new ContentValues();
        try {
            values.put(OperateFaqTable.Columns.SECTION_ID, sectionId);
            values.put(OperateFaqTable.Columns.FAQ_MAIN_ID, faq.optString("kmMainid"));
            values.put(OperateFaqTable.Columns.FAQ_TITLE, faq.optString("question"));
            values.put(OperateFaqTable.Columns.FAQ_CONTENT, faq.optString("content"));
            values.put(OperateFaqTable.Columns.FAQ_IMG_URL, faq.optString("imgUrl"));
            values.put(OperateFaqTable.Columns.FAQ_LAST_UPDATE_DATE, faq.optString("lastUpdateDate"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }
}
