package net.aihelp.db.op.controller;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import net.aihelp.common.Const;
import net.aihelp.db.op.OperateDBHelper;
import net.aihelp.db.op.pojo.OperateSection;
import net.aihelp.db.op.tables.OperateSectionTable;
import net.aihelp.db.util.ContentValuesUtil;
import net.aihelp.core.net.json.JsonHelper;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;


public class OperateSecDBController {

    private final OperateDBHelper dbHelper;
    private final OperateFaqDBController faqController;

    private OperateSecDBController() {
        this.dbHelper = OperateDBHelper.getInstance();
        faqController = OperateFaqDBController.getInstance();
    }

    public boolean isOperateStoredSuccessfully() {
        int amount;
        SQLiteDatabase database = dbHelper.getReadableDatabase();
        String sql = String.format("select * from %s where %s = '%s'",
                OperateSectionTable.TABLE_NAME, OperateSectionTable.Columns.OPERATE_FILE_NAME, Const.OP_FILE);
        Cursor c = database.rawQuery(sql, null);
        amount = c.getCount();
        c.close();
        return amount > 0;
    }

    public void storeOperateFaqs(JSONArray faqList) {
        dbHelper.clearDatabase();
        SQLiteDatabase database = null;
        try {
            database = dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (int i = 0; i < faqList.length(); i++) {
                JSONObject section = JsonHelper.getJsonObject(faqList, i);
                JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
                if (faqs.length() > 0) {
                    database.insert(OperateSectionTable.TABLE_NAME, null,
                            ContentValuesUtil.getOperateSectionValue(section));
                    String sectionId = section.optString("sectionId");
                    faqController.storeFaqs(sectionId, faqs);
                }
            }
            database.setTransactionSuccessful();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (database != null && database.inTransaction()) {
                try {
                    database.endTransaction();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<OperateSection> getOperateSections() {
        ArrayList<OperateSection> secList = new ArrayList<>();
        Cursor cursor = null;
        try {
            SQLiteDatabase database = dbHelper.getReadableDatabase();
            cursor = database.query(OperateSectionTable.TABLE_NAME, null, null,
                    null, null, null, null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    secList.add(getFromCursor(cursor));
                    cursor.moveToNext();
                }
            }
        }  catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return secList;
    }

    private OperateSection getFromCursor(Cursor cursor) {
        OperateSection section = new OperateSection();
        section.setSecId(cursor.getString(cursor.getColumnIndex(OperateSectionTable.Columns.SECTION_ID)));
        section.setSecTitle(cursor.getString(cursor.getColumnIndex(OperateSectionTable.Columns.SECTION_TITLE)));
        return section;
    }

    private static final class LazyHolder {
        static final OperateSecDBController INSTANCE = new OperateSecDBController();

        private LazyHolder() {
        }
    }

    public static OperateSecDBController getInstance() {
        return OperateSecDBController.LazyHolder.INSTANCE;
    }

}
