package net.aihelp.db.op.controller;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import net.aihelp.db.faq.tables.SectionTable;
import net.aihelp.db.op.OperateDBHelper;
import net.aihelp.db.op.pojo.OperateFaq;
import net.aihelp.db.op.tables.OperateFaqTable;
import net.aihelp.db.util.ContentValuesUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.security.spec.ECField;
import java.util.ArrayList;


public class OperateFaqDBController {

    private final OperateDBHelper dbHelper;

    private OperateFaqDBController() {
        this.dbHelper = OperateDBHelper.getInstance();
    }

    void storeFaqs(String sectionId, JSONArray faqs) {
        try {
            SQLiteDatabase database = dbHelper.getWritableDatabase();
            for (int i = 0; i < faqs.length(); i++) {
                JSONObject faq = faqs.getJSONObject(i);
                database.insertWithOnConflict(OperateFaqTable.TABLE_NAME, null,
                        ContentValuesUtil.getOperateFaqValue(sectionId, faq), SQLiteDatabase.CONFLICT_IGNORE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private OperateFaq cursorToFaq(Cursor cursor) {
        OperateFaq faqEntity = new OperateFaq();
        faqEntity.setFaqId(cursor.getString(cursor.getColumnIndex(OperateFaqTable.Columns.FAQ_MAIN_ID)));
        faqEntity.setFaqTitle(cursor.getString(cursor.getColumnIndex(OperateFaqTable.Columns.FAQ_TITLE)));
        faqEntity.setFaqContent(cursor.getString(cursor.getColumnIndex(OperateFaqTable.Columns.FAQ_CONTENT)));
        faqEntity.setSecId(cursor.getString(cursor.getColumnIndex(OperateFaqTable.Columns.SECTION_ID)));
        faqEntity.setFaqImageUrl(cursor.getString(cursor.getColumnIndex(OperateFaqTable.Columns.FAQ_IMG_URL)));
        faqEntity.setFaqUpdateDate(cursor.getString(cursor.getColumnIndex(OperateFaqTable.Columns.FAQ_LAST_UPDATE_DATE)));
        return faqEntity;
    }

    public ArrayList<OperateFaq> getOperateFaqsById(String secId) {
        ArrayList<OperateFaq> faqList = new ArrayList<>();
        Cursor cursor = null;
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(OperateFaqTable.TABLE_NAME, null,
                    "section_id = ?", new String[]{secId}, null, null,  null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    faqList.add(cursorToFaq(cursor));
                    cursor.moveToNext();
                }
            }
        }  catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return faqList;
    }

    public synchronized OperateFaq getFaq(String faqId) {
        OperateFaq faq = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(OperateFaqTable.TABLE_NAME, null,
                    "faq_main_id = ?", new String[]{faqId}, null, null, null);
            if (cursor.moveToFirst()) {
                faq = cursorToFaq(cursor);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return faq;
    }

    private static final class LazyHolder {
        static final OperateFaqDBController INSTANCE = new OperateFaqDBController();

        private LazyHolder() {
        }

    }

    public static OperateFaqDBController getInstance() {
        return OperateFaqDBController.LazyHolder.INSTANCE;
    }

}
