package net.aihelp.db.op;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.db.BaseSQLiteHelper;
import net.aihelp.core.db.DropAndCreateDatabaseHelper;
import net.aihelp.core.db.IDatabaseContract;
import net.aihelp.core.db.IMigrateContract;
import net.aihelp.db.faq.tables.FaqTable;
import net.aihelp.db.faq.tables.SectionTable;
import net.aihelp.db.faq.tables.SubSectionTable;
import net.aihelp.db.op.tables.OperateFaqTable;
import net.aihelp.db.op.tables.OperateSectionTable;
import net.aihelp.utils.LocalizeHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


public class OperateDBHelper extends BaseSQLiteHelper {

    private static final String CREATE_OP_FAQ_TABLE = "CREATE TABLE op_faq (_id INTEGER PRIMARY KEY AUTOINCREMENT,faq_main_id TEXT NOT NULL UNIQUE, faq_title TEXT NOT NULL,faq_content TEXT NOT NULL, section_id TEXT NOT NULL, img_url TEXT, last_update_date TEXT);";
    private static final String CREATE_OP_SECTION_TABLE = "CREATE TABLE op_section (_id INTEGER PRIMARY KEY AUTOINCREMENT,section_id TEXT NOT NULL UNIQUE,section_title INTEGER,section_order TEXT NOT NULL, operate_file_name TEXT NOT NULL);";

    private OperateDBHelper(Context context, IDatabaseContract contract) {
        super(context, contract);
    }

    public static OperateDBHelper getInstance() {
        return OperateDBHelper.LazyHolder.INSTANCE;
    }

    private static class LazyHolder {

        static final OperateDBHelper INSTANCE = new OperateDBHelper(
                AIHelpContext.getInstance().getContext(), new IDatabaseContract() {

            @Override
            public int getDatabaseVersion() {
                return 1;
            }

            @Override
            public String getDatabaseName() {
                return "OperateDatabase";
            }

            @Override
            public List<String> getCreateTableQueries() {
                return Arrays.asList(CREATE_OP_FAQ_TABLE, CREATE_OP_SECTION_TABLE);
            }

            @Override
            public List<IMigrateContract> getMigratorsForUpgrade(int oldDbVersion) {
                List<IMigrateContract> contractList = new ArrayList<>();
                contractList.add(new DropAndCreateDatabaseHelper(this));
                return contractList;
            }

            @Override
            public List<String> getTableNames() {
                return Arrays.asList(OperateFaqTable.TABLE_NAME, OperateSectionTable.TABLE_NAME);
            }

            @Override
            public String getTag() {
                return "AIHelp_DB_FAQ";
            }

        });
    }

}
