package net.aihelp.db.faq.pojo;

import android.os.Parcel;
import android.os.Parcelable;


public class Section implements Parcelable {

    public static final Creator<Section> CREATOR = new Creator<Section>() {
        @Override
        public Section createFromParcel(Parcel in) {
            return new Section(in);
        }

        @Override
        public Section[] newArray(int size) {
            return new Section[size];
        }
    };

    private String secId;
    private String secTitle;
    private boolean hasSubSection;

    public Section() {
    }

    protected Section(Parcel in) {
        secId = in.readString();
        secTitle = in.readString();
        hasSubSection = in.readByte() != 0;
    }

    public String getSecId() {
        return secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecTitle() {
        return secTitle;
    }

    public void setSecTitle(String secTitle) {
        this.secTitle = secTitle;
    }

    public boolean isHasSubSection() {
        return hasSubSection;
    }

    public void setHasSubSection(boolean hasSubSection) {
        this.hasSubSection = hasSubSection;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(secId);
        dest.writeString(secTitle);
        dest.writeByte((byte) (hasSubSection ? 1 : 0));
    }
}
