package net.aihelp.db.faq.filter;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;


public class FaqTagFilter implements Serializable {

    private static final long serialVersionUID = 7526472295622776147L;
    private String operator = "undefined";
    private String[] tags;

    public FaqTagFilter(String operator, String[] tags) {
        if (FaqTagFilter.Operator.valueSet.contains(operator)) {
            this.operator = operator;
        }

        this.tags = tags;
    }

    public String getOperator() {
        return this.operator;
    }

    public String[] getTags() {
        return this.tags;
    }

    protected Map<String, Object> toMap() {
        Map<String, Object> faqTagFilter = null;
        if (this.operator != null && FaqTagFilter.Operator.valueSet.contains(this.operator) && this.tags != null && this.tags.length > 0) {
            faqTagFilter = new HashMap();
            faqTagFilter.put("operator", this.operator);
            faqTagFilter.put("tags", this.tags);
        }

        return faqTagFilter;
    }

    public boolean equals(Object otherObject) {
        return otherObject instanceof FaqTagFilter && this.operator.equals(((FaqTagFilter)otherObject).operator) && Arrays.equals(this.tags, ((FaqTagFilter)otherObject).tags);
    }

    public static class Operator {

        public static final String AND = "and";
        public static final String OR = "or";
        public static final String NOT = "not";
        public static final String UNDEFINED = "undefined";
        public static final HashSet<String> valueSet = getSupportedValueSet();

        public Operator() {
        }

        private static HashSet<String> getSupportedValueSet() {
            HashSet<String> valueSet = new HashSet<>();
            valueSet.add("and");
            valueSet.add("or");
            valueSet.add("not");
            return valueSet;
        }
    }

}
