package net.aihelp.db.faq;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.db.BaseSQLiteHelper;
import net.aihelp.core.db.DropAndCreateDatabaseHelper;
import net.aihelp.core.db.IDatabaseContract;
import net.aihelp.core.db.IMigrateContract;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.db.faq.tables.FaqTable;
import net.aihelp.db.faq.tables.SectionTable;
import net.aihelp.db.faq.tables.SubSectionTable;
import net.aihelp.utils.LocalizeHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


public class FaqDBHelper extends BaseSQLiteHelper {

    private static final String CREATE_FAQ_TABLE = "CREATE TABLE faq (_id INTEGER PRIMARY KEY AUTOINCREMENT,faq_main_id TEXT NOT NULL UNIQUE, faq_display_id TEXT, faq_title TEXT NOT NULL,faq_content TEXT NOT NULL,faq_content_no_html TEXT NOT NULL, section_id TEXT NOT NULL,faq_content_id TEXT NOT NULL,is_helpful INTEGER);";
    private static final String CREATE_SECTION_TABLE = "CREATE TABLE section (_id INTEGER PRIMARY KEY AUTOINCREMENT,section_id TEXT NOT NULL UNIQUE,section_title TEXT NOT NULL,section_order INTEGER,has_sub_section TEXT NOT NULL, faq_file_name TEXT NOT NULL);";
    private static final String CREATE_SUB_SECTION_TABLE = "CREATE TABLE sub_section (_id INTEGER PRIMARY KEY AUTOINCREMENT,section_id TEXT NOT NULL,sub_section_id TEXT NOT NULL UNIQUE,sub_section_title TEXT NOT NULL,sub_section_order INTEGER);";

    private FaqDBHelper(Context context, IDatabaseContract contract) {
        super(context, contract);
    }

    public static FaqDBHelper getInstance() {
        return FaqDBHelper.LazyHolder.INSTANCE;
    }

    private static class LazyHolder {

        static final FaqDBHelper INSTANCE = new FaqDBHelper(
                AIHelpContext.getInstance().getContext(), new IDatabaseContract() {

            @Override
            public int getDatabaseVersion() {
                return 1;
            }

            @Override
            public String getDatabaseName() {
                return "FaqDatabase";
            }

            @Override
            public List<String> getCreateTableQueries() {
                return Arrays.asList(CREATE_FAQ_TABLE, CREATE_SECTION_TABLE, CREATE_SUB_SECTION_TABLE);
            }

            @Override
            public List<IMigrateContract> getMigratorsForUpgrade(int oldDbVersion) {
                List<IMigrateContract> contractList = new ArrayList<>();
                contractList.add(new DropAndCreateDatabaseHelper(this));
                return contractList;
            }

            @Override
            public List<String> getTableNames() {
                return Arrays.asList(FaqTable.TABLE_NAME, SectionTable.TABLE_NAME, SubSectionTable.TABLE_NAME);
            }

            @Override
            public String getTag() {
                return "AIHelp_DB_FAQ";
            }

        });
    }

}
