package net.aihelp.db.bot;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.db.BaseSQLiteHelper;
import net.aihelp.core.db.DropAndCreateDatabaseHelper;
import net.aihelp.core.db.IDatabaseContract;
import net.aihelp.core.db.IMigrateContract;
import net.aihelp.db.faq.tables.FaqTable;
import net.aihelp.db.faq.tables.SectionTable;
import net.aihelp.db.faq.tables.SubSectionTable;
import net.aihelp.utils.LocalizeHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;


public class ConversationDBHelper extends BaseSQLiteHelper {

    private static final String CREATE_ELVA_TABLE = "CREATE TABLE elva_bot (_id INTEGER PRIMARY KEY AUTOINCREMENT, uid TEXT NOT NULL, app_id TEXT NOT NULL, app_server TEXT NOT NULL, time_stamp INTEGER UNIQUE,raw_response TEXT NOT NULL);";

    private ConversationDBHelper(Context context, IDatabaseContract contract) {
        super(context, contract);
    }

    public static ConversationDBHelper getInstance() {
        return ConversationDBHelper.LazyHolder.INSTANCE;
    }

    private static class LazyHolder {

        static final ConversationDBHelper INSTANCE = new ConversationDBHelper(
                AIHelpContext.getInstance().getContext(), new IDatabaseContract() {

            @Override
            public int getDatabaseVersion() {
                return 1;
            }

            @Override
            public String getDatabaseName() {
                return "ConversationDatabase";
            }

            @Override
            public List<String> getCreateTableQueries() {
                return Collections.singletonList(CREATE_ELVA_TABLE);
            }

            @Override
            public List<IMigrateContract> getMigratorsForUpgrade(int oldDbVersion) {
                List<IMigrateContract> contractList = new ArrayList<>();
                contractList.add(new DropAndCreateDatabaseHelper(this));
                return contractList;
            }

            @Override
            public List<String> getTableNames() {
                return Arrays.asList(FaqTable.TABLE_NAME, SectionTable.TABLE_NAME, SubSectionTable.TABLE_NAME);
            }

            @Override
            public String getTag() {
                return "AIHelp_DB_CONVERSATION";
            }

        });
    }

}
