package net.aihelp.data.model.cs;

import net.aihelp.core.net.json.GenericType;
import net.aihelp.ui.helper.LogoutMqttHelper;

import java.util.List;


public class ElvaBotMsg extends ConversationMsg {

    public ElvaBotMsg() {
        setMsgType(TYPE_ADMIN_TEXT);
        setTimeStamp(System.currentTimeMillis());
    }

    private boolean hasAction;
    private boolean hasUrl;
    private boolean hasFormUrl;
    private boolean hasTag;

    private String rawResponse;
    private String botMsg;
    private String userInput;
    private boolean isBotStupid;
    @GenericType(value = String.class)
    private List<String> actions;
    @GenericType(value = BotTag.class)
    private List<BotTag> botTagList;
    private BotUrl botUrl;
    private BotFormUrl botFormUrl;
    private boolean isSimilarMatched;
    private String faqId;
    private String template;

    public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getFaqId() {
        return faqId;
    }

    public void setFaqId(String faqId) {
        this.faqId = faqId;
    }

    public boolean isSimilarMatched() {
        return isSimilarMatched;
    }

    public void setSimilarMatched(boolean similarMatched) {
        isSimilarMatched = similarMatched;
    }

    public String getRawResponse() {
        return rawResponse;
    }

    public void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }

    public boolean isBotStupid() {
        return isBotStupid;
    }

    public void setBotStupid(boolean botStupid) {
        isBotStupid = botStupid;
    }

    public boolean isHasAction() {
        return hasAction;
    }

    public boolean isHasUrl() {
        return hasUrl;
    }

    public boolean isHasFormUrl() {
        return hasFormUrl;
    }

    public boolean isHasTag() {
        return hasTag;
    }

    public String getBotMsg() {
        return botMsg;
    }

    public void setBotMsg(String botMsg) {
        this.botMsg = botMsg;
    }

    public String getUserInput() {
        return userInput;
    }

    public void setUserInput(String userInput) {
        this.userInput = userInput;
    }

    public List<String> getActions() {
        return actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
        setHasAction();
    }

    public List<BotTag> getBotTagList() {
        return botTagList;
    }

    public void setBotTagList(List<BotTag> botTagList) {
        this.botTagList = botTagList;
        setHasTag();
    }

    public BotUrl getBotUrl() {
        return botUrl;
    }

    public void setBotUrl(BotUrl botUrl) {
        this.botUrl = botUrl;
        setHasUrl();
    }

    public BotFormUrl getBotFormUrl() {
        return botFormUrl;
    }

    public void setBotFormUrl(BotFormUrl botFormUrl) {
        this.botFormUrl = botFormUrl;
        setHasFormUrl();
    }

    private void setHasAction() {
        this.hasAction = true;
        LogoutMqttHelper.updateType(LogoutMqttHelper.LOGOUT_TYPE_ACTION_DISPLAY);
    }

    private void setHasUrl() {
        this.hasUrl = true;
    }

    private void setHasFormUrl() {
        this.hasFormUrl = true;
        LogoutMqttHelper.updateType(LogoutMqttHelper.LOGOUT_TYPE_FORM_DISPLAY);
    }

    private void setHasTag() {
        this.hasTag = true;
    }

}
