package net.aihelp.data.model.cs;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;

import net.aihelp.ui.helper.BitmapHelper;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.TLog;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.regex.Pattern;


public class ConversationMsg {

    public ConversationMsg() {
        setTimeStamp(System.currentTimeMillis());
    }

    public ConversationMsg(int msgType, int msgStatus) {
        this();
        this.msgType = msgType;
        this.msgStatus = msgStatus;
    }

    public static final int TYPE_ADMIN_TEXT = 1;
    public static final int TYPE_USER_TEXT = 2;
    public static final int TYPE_USER_TEXT_BOT = 3;
    public static final int TYPE_TIMESTAMP = 4;
    public static final int TYPE_ADMIN_FAQ = 5;
    public static final int TYPE_USER_IMAGE = 6;
    public static final int TYPE_USER_VIDEO = 7;
    public static final int TYPE_ADMIN_IMAGE = 8;
    public static final int TYPE_ADMIN_VIDEO = 9;
    public static final int TYPE_ADMIN_RICHTEXT = 10;

    public static final int STATUS_FAQ_NORMAL = 100;
    public static final int STATUS_FAQ_HELPFUL = 200;
    public static final int STATUS_FAQ_UNHELPFUL = 300;

    public static final int STATUS_SENDING = 1001;
    public static final int STATUS_RETRY = 1002;
    public static final int STATUS_SUCCESS = 1003;
    public static final int STATUS_FAILURE = 1004;

    private String nickname;
    private int msgType;
    private int msgStatus;
    private long timeStamp;
    private String msgContent;
    private String videoThumbnail;
    private int[] imageSize;
    private boolean isMessageFromServer;
    private String faqTicketId;

    public String getFaqTicketId() {
        return faqTicketId;
    }

    public void setFaqTicketId(String faqTicketId) {
        this.faqTicketId = faqTicketId;
    }

    public String getNickname() {
        if (TextUtils.isEmpty(nickname)) {
            return "";
        }
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getVideoThumbnail() {
        return videoThumbnail;
    }

    public void setVideoThumbnail(String videoThumbnail) {
        this.videoThumbnail = videoThumbnail;
        setImageSize(BitmapHelper.computeSize(videoThumbnail));
    }

    public int[] getImageSize() {
        return imageSize;
    }

    public void setImageSize(int[] imageSize) {
        this.imageSize = imageSize;
    }

    public void setMessageFromServer(boolean messageFromServer) {
        isMessageFromServer = messageFromServer;
    }

    public boolean isMessageFromServer() {
        return isMessageFromServer;
    }

    public String getMsgContent() {
        return msgContent;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }

    public int getMsgType() {
        return msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public int getMsgStatus() {
        return msgStatus;
    }

    public void setMsgStatus(int msgStatus) {
        this.msgStatus = msgStatus;
    }

    public long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void prepareVideoThumbnail() {
        try {

            String videoPath = getMsgContent();
            boolean isLocalFile = Pattern.compile("^(/.+)+\\.(mp4|MP4)$").matcher(videoPath).matches();

            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            if (isLocalFile) {
                mmr.setDataSource(videoPath);
            } else {
                mmr.setDataSource(videoPath, new HashMap<String, String>());
            }

            Bitmap bitmap = mmr.getFrameAtTime();
            File f = MediaUtils.getOutputMediaFile(MediaUtils.MEDIA_TYPE_IMAGE);
            if (f != null) {
                try {
                    FileOutputStream out = new FileOutputStream(f);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, out);
                    out.flush();
                    out.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                setVideoThumbnail(f.getAbsolutePath());
            }
            mmr.release();
        } catch (Exception e) {
            e.printStackTrace();
            TLog.e("prepareVideoThumbnail failed, " + e.toString());
        }

    }


}
