package net.aihelp.data.logic;

import android.content.Context;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.db.op.pojo.OperateFaq;
import net.aihelp.ui.op.OperateContentFragment;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;

import org.json.JSONObject;


public class OperatePresenter extends AbsPresenter<OperateContentFragment, IRepository> {

    private static final ApiExecutor sApiExecutor = ApiExecutorFactory.getHandlerExecutor();

    public OperatePresenter(Context context) {
        super(context);
    }

    public void goFetchOperateContent(final String faqId) {
        final OperateFaq faq = AIHelpDBHelper.getInstance().getOperateFaq(faqId);
        if (faq != null) {
            sApiExecutor.runAsync(new Runnable() {
                @Override
                public void run() {
                    sApiExecutor.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            mView.refreshOperateContent(faq);
                        }
                    });
                }
            });
        } else {
            mView.showEmpty();
        }
    }

}
