package net.aihelp.data.logic;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.widget.Toast;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.mvp.IView;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.ui.helper.LogoutMqttHelper;
import net.aihelp.utils.TLog;

import org.json.JSONArray;
import org.json.JSONObject;


public abstract class MqttPresenter<V extends IView, R extends IRepository> extends AbsPresenter<V, R> {

    public MqttPresenter(Context context) {
        super(context);
    }

    public boolean isNetworkAvailable() {
        if (mContext == null) return false;
        ConnectivityManager cm = (ConnectivityManager) mContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public boolean validateNetwork() {
        boolean isAvailable = isNetworkAvailable();
        if (!isAvailable) {
            Toast.makeText(mContext, mContext.getString(net.aihelp.R.string.aihelp_network_no_connect), Toast.LENGTH_SHORT).show();
        }
        return isAvailable;
    }

    public void logoutMqtt(boolean isConversation) {
        try {

//            if (!MqttConfig.getInstance().isConnected()) return;
            JSONObject logoutParams = new JSONObject();
            JSONArray msgArray = AIHelpDBHelper.getInstance().getElvaMsgArray();
            logoutParams.put("type", isConversation ? MqttConfig.TYPE_CONVERSATION : MqttConfig.TYPE_ELVA_BOT);
            logoutParams.put("feedback", LogoutMqttHelper.getLogoutType());
            logoutParams.put("gameinfo", String.format("{\"platform\":\"android\",\"language\":\"%s\"}", Const.TARGET_LAN));
            logoutParams.put("session_msgs", msgArray);
            logoutParams.put("tags", LogoutMqttHelper.getTagsFromMessageList(msgArray));
            AIHelpMqtt.getInstance().postToServer((API.TOPIC_LOGOUT), logoutParams);

            LogoutMqttHelper.resetTypeWhenLogout();
            AIHelpDBHelper.getInstance().clearElvaMsg();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
