package net.aihelp.data.local;

import android.content.Context;
import android.text.TextUtils;

import net.aihelp.common.Const;
import net.aihelp.common.SpKeys;
import net.aihelp.config.UserConfig;
import net.aihelp.core.mvp.AbsRepository;
import net.aihelp.data.model.InitEntity;
import net.aihelp.data.model.SDKConfigEntity;
import net.aihelp.data.model.UpdateCDNFileEntity;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.LocaleUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.TLog;

import org.json.JSONObject;

import java.util.Locale;


public class InitRepository extends AbsRepository {

    public InitRepository(Context context) {
        super(context);
    }

    public void saveDAULogTime(long logTime) {
        doSave(SpKeys.LOG_DAU_TIME, logTime);
    }

    private void saveInitResponse(int cachePeriod, String initResponse, long lastInitTime) {
        doSave(SpKeys.INIT_REQUEST_LIMIT, cachePeriod < 0 ? cachePeriod : cachePeriod * 60 * 1000);
        doSave(SpKeys.CACHE_INIT_RESPONSE, initResponse);
        doSave(SpKeys.LAST_INIT_TIME, lastInitTime);
    }

    public void prepareInitData(InitEntity initEntity, String initResponse, long lastInitTime) {

        saveInitResponse(initEntity.getRequestLimit(), initResponse, lastInitTime);

        updateAPI("API.CDN_URL", initEntity.getCdnUrl());
        updateAPI("API.FAQ_URL", initEntity.getFaqdata());
        updateAPI("API.OP_URL", initEntity.getFaqYYdata());
        updateAPI("API.FORM_URL", initEntity.getFaqdataForm());
        updateAPI("API.UPLOAD_URL", initEntity.getUpload());
        updateAPI("API.UPLOAD_VIDEO_URL", initEntity.getUploadVideo());
        updateAPI("API.UPLOAD_FILE_URL", initEntity.getUploadLog());
        updateAPI("API.M_FAQ_URL", initEntity.getShowfaq());

        updateAPI("API.LOG_COUNT_URL", initEntity.getPoint());
        updateAPI("API.CONFIG_FILE_URL", initEntity.getConfigFileName());

        updateAPI("API.MQTT_IP", initEntity.getSvrip());
        updateAPI("API.MQTT_PORT", initEntity.getSvrport());
        updateAPI("API.MQTT_TOPIC", initEntity.getTopic());
        if (!TextUtils.isEmpty(initEntity.getPushServer())) {
            String[] faqMqtt = initEntity.getPushServer().split(":");
            if (faqMqtt.length == 2) {
                updateAPI("API.MQTT_FAQ_IP", faqMqtt[0]);
                updateAPI("API.MQTT_FAQ_PORT", faqMqtt[1]);
            }
        }

        updateConst("Const.TOGGLE_UPLOAD_VIDEO", initEntity.isOpenVideoUpload());
        updateConst("Const.TOGGLE_CRM_TOKEN", initEntity.isSetCrmToken());
        updateConst("Const.TOGGLE_OPEN_FAQ_NOTIFICATION", initEntity.isOpenPushServer());
        updateConst("Const.TOGGLE_OPEN_UNREAD_MSG", initEntity.isUnreadMessage());
        updateConst("Const.TOGGLE_UPLOAD_LOG", initEntity.isOpenUploadLogFile());
        updateConst("Const.TOGGLE_LOCALIZE_VIA_INIT", initEntity.isLocalizeFAQViaInit());

        updateConst("Const.FAQ_FILE", initEntity.getFaqFileName());
        updateConst("Const.STORY_FILE", initEntity.getStoryAimlFileName());
        updateConst("Const.OP_FILE", initEntity.getOperateFileName());
        updateConst("Const.LIMIT_CHECKING_UNREAD", initEntity.getUnreadMessageTime());
        updateConst("Const.LIMIT_UPLOADING_VIDEO", initEntity.getVideoUploadSizeLimit());
        updateConst("Const.APP_SHOW_NAME", AppInfoUtil.getAppName(mContext));

        if (initEntity.getNetworkCheckSetting() != null) {
            updateConst("Const.TOGGLE_NET_CHECK", true);
            updateConst("Const.NET_TRACE_ROUTE", initEntity.getNetworkCheckSetting().getTraceroute());
            updateConst("Const.NET_PING", initEntity.getNetworkCheckSetting().getPing());
        }

        if (initEntity.getCustomInformation() != null) {
            Const.PRIVACY_CONTROL_DATA = initEntity.getCustomInformation().toJsonString();
        }

    }

    public void saveInitConfig(String appKey, String domain, String appId, String initLanguage) {
        updateConst("Const.APP_KEY", appKey);
        if (Const.isRunAccelerationForChina) domain = domain + ".cn";
        updateAPI("API.HOST_URL", domain.replace("https://", "").replace("http://", ""));
        updateConst("Const.APP_ID", appId);

        String previousLan = LocaleUtil.getSDKLanguage();
        String deviceLan = Locale.getDefault().toString();
        if (!TextUtils.isEmpty(previousLan)) {
            updateConst("Const.TARGET_LAN", LocaleUtil.getFormatLanguage(previousLan));
        } else if (!TextUtils.isEmpty(initLanguage) && !initLanguage.equals(deviceLan)) {
            updateConst("Const.TARGET_LAN", LocaleUtil.getFormatLanguage(initLanguage));
        } else {
            updateConst("Const.TARGET_LAN", LocaleUtil.getFormatLanguage(deviceLan));
        }

        // 对用户数据做初始化，在 updateUserInfo 调用之前，保证不为空
        updateUserProfile("UserProfile.USER_ID", DeviceUuidFactory.id(mContext));
        updateUserProfile("UserProfile.SERVER_ID", "-1");
        updateUserProfile("UserProfile.USER_NAME", "anonymous");
    }

    public void saveSDKConfig(SDKConfigEntity configEntity) {
        if (configEntity != null) {
            SDKConfigEntity.SdkTextBean sdkText = configEntity.getSdkText();
            updateNameAndWelcome(sdkText);

            SDKConfigEntity.SdkConfigBean sdkConfig = configEntity.getSdkConfig();
            if (sdkConfig != null) {
                updateConst("Const.TOGGLE_SHOW_NICKNAME", sdkConfig.getIs_Output_Nike());
                updateConst("Const.TOGGLE_SHOW_PORTRAIT", sdkConfig.getAvatar_Enable());
                updateConst("Const.TOGGLE_GET_LAST_CONVERSATION", sdkConfig.getIs_Psee_Chat_History());
                updateConst("Const.TOGGLE_EVALUATE_BOT_FAQ", sdkConfig.getPlayerEvalFaqReply());
                updateConst("Const.TOGGLE_EVALUATE_DETAIL_FAQ", sdkConfig.getPlayerEvalFaqDetail());
                updateConst("Const.TOGGLE_CHAT_TIMESTAMP", sdkConfig.getPlayerSeeChatTime());
            }
        }
    }

    public void updateNameAndWelcome(SDKConfigEntity.SdkTextBean sdkText) {
        if (sdkText != null) {
            if (!TextUtils.isEmpty(sdkText.getShowAppName()))
                updateConst("Const.APP_SHOW_NAME", sdkText.getShowAppName());
            if (!TextUtils.isEmpty(sdkText.getPhoneWel()))
                updateConst("Const.DASHBOARD_WELCOME_MSG", sdkText.getPhoneWel());
        }
    }

    public void updateSDKLanguage(String sdkLanguage) {
//        SpUtil.getInstance().put(SpKeys.SDK_LANGUAGE, sdkLanguage);
        updateConst("Const.TARGET_LAN", sdkLanguage);
    }

    public void resetSDKLanguage(String sdkLanguage) {
        SpUtil.getInstance().put(SpKeys.SDK_LANGUAGE, "");
        updateConst("Const.TARGET_LAN", sdkLanguage);
    }

    public void updateFileNameWhenLanguageUpdated(String sdkLanguage, UpdateCDNFileEntity result) {
        updateAPI("API.CDN_URL", result.getCdnUrl());
        updateConst("Const.FAQ_FILE", result.getFaqFileName());
        updateConst("Const.STORY_FILE", result.getStoryAimlFileName());
        updateConst("Const.OP_FILE", result.getOperateFileName());
    }

    public void saveUserProfileConfig(UserConfig config) {
        updateUserProfile("UserProfile.CUSTOM_DATA", config.getFormatCustomData());
        updateUserProfile("UserProfile.USER_ID", config.getUserId());
        updateUserProfile("UserProfile.USER_NAME", config.getUserName());
        updateUserProfile("UserProfile.SERVER_ID", config.getServerId());
    }

    /**
     * DO NOT check whether the parameter is empty or not.
     * For example, if set storyNode in A page, the Const.CUSTOM_STORY_NODE will remember A's storyNode value for
     * the whole app lifecycle, unless there is another non-empty value assigned.
     * In this case, if you are trying to showConversation in B page, you will get a A's story lines.
     */
    public void updateConversationFields(String welcomeMsg, String storyNode) {
        updateConst("Const.CUSTOM_WELCOME_MSG", welcomeMsg);
        updateConst("Const.CUSTOM_STORY_NODE", storyNode);
    }

    public void setUploadLogPath(String logPath) {
        updateConst("Const.LOG_UPLOAD_PATH", logPath);
    }

    public void setNetworkCheckHostAddress(String hostAddress) {
        updateConst("Const.NET_CHECK_HOST", hostAddress);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        updateConst("Const.SCREEN_ORIENTATION", requestedOrientation);
    }

    public void saveMqttPushInfo(String pushToken, int pushPlatform) {
        updateConst("Const.PUSH_INFO", String.format("%s|%s", pushToken, pushPlatform));
    }

}
