package net.aihelp.core.util.permission;

import android.app.Activity;

import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.config.HttpConfig;

import androidx.fragment.app.Fragment;
import okhttp3.OkHttpClient;


public class AIHelpPermissions {

    private Object object;
    private int requestCode = 0;
    private String permission;

    private PermissionHelper helper;

    private AIHelpPermissions() {

    }

    public void requestPermissions(Activity activity, String permission, int requestCode) {
        setHost(activity).setRequestPermission(permission).setRequestCode(requestCode).request();
    }

    public AIHelpPermissions setHost(Object object) {
        this.object = object;
        return this;
    }

    public AIHelpPermissions setRequestPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public AIHelpPermissions setRequestCode(int requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    public void request() {

        helper = PermissionHelper.getInstance(object, permission, requestCode);
        switch (helper.checkPermissionState()) {
            case AVAILABLE:
                helper.invokePermissionCallback(Permission.Result.GRANTED);
                break;
            case UNAVAILABLE:
                helper.invokePermissionCallback(Permission.Result.NONE);
                break;
            case RATIONAL:
                helper.invokePermissionCallback(Permission.Result.RATIONAL);
                break;
            case ASKABLE:
                helper.requestPermission();
                break;
        }

    }

    public void onRequestPermissionsResult(boolean isPermissionGranted) {
        if (helper != null) {
            helper.onRequestPermissionsResult(isPermissionGranted);
        }
    }

    private static AIHelpPermissions sInstance;

    public static AIHelpPermissions getInstance() {
        if (sInstance == null) {
            synchronized (PermissionHelper.class) {
                if (sInstance == null) {
                    sInstance = new AIHelpPermissions();
                }
            }
        }
        return sInstance;
    }

}
