package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

public class Url extends TemplateElement {

    private String title;
    private String content;

    public Url() {
    }

    public Url(Attributes attributes) {
        title = attributes.getValue("title");
        content = attributes.getValue("content");
    }

    public Url(String title, String content, Object... children) {
        super(children);
        this.title = title;
        this.content = content;
    }
  
    private boolean isEquals(Object comparing, Object compared) {
        return (comparing == null ? compared == null : comparing.equals(compared));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Url compared = (Url) obj;
        return (isEquals(title, compared.title) && isEquals(content, compared.content));
    }
  
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String process(Match match) {
        try {
            return String.format("<url title='%s' content='%s'></url>", title.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"), content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"));
        } catch (NullPointerException e) {
            return "";
        }
    }
}