package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

import static net.aihelp.core.util.elva.Match.Section.THAT;

public class Thatstar extends TemplateElement {

    private int index;

    public Thatstar(Attributes attributes) {
        String value = attributes.getValue(0);
        if (value == null) {
            index = 1;
        } else {
            index = Integer.parseInt(value);
        }
    }

    public Thatstar(int index) {
        this.index = index;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) return false;
        Thatstar compared = (Thatstar) obj;

        return (index == compared.index);
    }

    public String toString() {
        return "<thatstar index=\"" + index + "\">";
    }

    public String process(Match match) {
        String wildcard = match.wildcard(THAT, index);
        return (wildcard != null ? wildcard.trim() : "");
    }
}