package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import java.lang.System;
import java.util.ArrayList;
import java.util.List;

import net.aihelp.core.util.elva.Match;

public class Category implements AIMLElement {

    private Pattern pattern;
    private Template template;
    private That that;
    private Topic topic;
    private List<Action> actions = new ArrayList<>();
    private List<Tag> tags = new ArrayList<>();
    private Url url = null;
    private Url2 url2 = null;
    private Alicekm alicekm = null;

    public Category() {
    }

    public Category(Attributes attributes) {
    }

    public Category(String pattern, Object... children) {
        this(new Pattern(pattern), new That("*"), new Topic("*"), new Template(children));
    }

    public Category(Pattern pattern, Template template) {
        this(pattern, new That("*"), new Topic("*"), template);
    }

    public Category(Pattern pattern, That that, Template template) {
        this(pattern, that, new Topic("*"), template);
    }

    public Category(Pattern pattern, That that, Topic topic, Template template) {
        this(pattern, that, topic, template, new Url(), new Url2(), new Alicekm(), new ArrayList<Tag>());
    }

    public Category(Pattern pattern, That that, Topic topic, Template template, Url url, Url2 url2, Alicekm alicekm, List<Tag> tags, Action... actions) {
        this.pattern = pattern;
        this.template = template;
        this.that = that;
        this.topic = topic;
        this.url = url;
        this.url2 = url2;
        this.actions = new ArrayList<Action>();
        this.tags = new ArrayList<Tag>();
        this.alicekm = alicekm;
        for (Action child : actions) {
            this.actions.add(child);
        }
        for (Tag tag : tags) {
            this.tags.add(tag);
        }
    }

    public void appendChild(AIMLElement child) {
        if (child instanceof Pattern) {
            pattern = (Pattern) child;
        } else if (child instanceof That) {
            that = (That) child;
        } else if (child instanceof Url) {
            url = (Url) child;
        } else if (child instanceof Url2) {
            url2 = (Url2) child;
        } else if (child instanceof Action) {
            actions.add((Action) child);
        } else if (child instanceof Tag) {
            tags.add((Tag) child);
        } else if (child instanceof Alicekm) {
            alicekm = (Alicekm) child;
        } else if (child instanceof Template) {
            template = (Template) child;
        } else {
            throw new ClassCastException("Invalid element of type " + child.getClass().getName() + ": (" + child + ")");
        }
    }

    public void appendChildren(List<AIMLElement> children) {
        for (AIMLElement child : children) {
            appendChild(child);
        }
        if (that == null) {
            that = new That("*");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Category)) {
            return false;
        }
        Category compared = (Category) obj;
        return (pattern.equals(compared.pattern) &&
                template.equals(compared.template) &&
                that.equals(compared.that));
    }

    public String toString() {
        return "[" + pattern.toString() + "][" + that.toString() + "][" + template.toString() + "]";
    }

    public String process(Match match) {
        if (url != null) {
            url.process(match);
        }
        if (url2 != null) {
            url2.process(match);
        }
        return template.process(match);
    }

    public String[] getMatchPath() {
        String[] pattPath = pattern.getElements();
        String[] thatPath = that.elements();
        String[] topicPath = topic.elements();
        int m = pattPath.length;
        int n = thatPath.length;
        int o = topicPath.length;
        String[] matchPath = new String[m + 1 + n + 1 + o];
        matchPath[m] = "<THAT>";
        matchPath[m + 1 + n] = "<TOPIC>";
        System.arraycopy(pattPath, 0, matchPath, 0, m);
        System.arraycopy(thatPath, 0, matchPath, m + 1, n);
        System.arraycopy(topicPath, 0, matchPath, m + 1 + n + 1, o);
        return matchPath;
    }

    public Pattern getPattern() {
        return pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Template getTemplate() {
        return template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public That getThat() {
        return that;
    }

    public void setThat(That that) {
        this.that = that;
    }

    public Topic getTopic() {
        return topic;
    }

    public Url getUrl() {
        return url;
    }

    public Url2 getUrl2() {
        return url2;
    }

    public Alicekm getAlicekm() {
        return alicekm;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public List<Action> getActions() {
        return actions;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }
}