package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

public class Action extends TemplateElement {

    private String name;
    private String reply;
  
    public Action() {
    }

    public Action(Attributes attributes) {
        name = attributes.getValue("name");
        reply = attributes.getValue("reply");
    }

    public Action(String name, String reply, Object... children) {
        super(children);
        this.name = name;
        this.reply = reply;
    }
  
    private boolean isEquals(Object comparing, Object compared) {
        return (comparing == null ? compared == null : comparing.equals(compared));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Action compared = (Action) obj;
        return (isEquals(name, compared.name) && isEquals(reply, compared.reply));
    }
  
    public String getTitle() {
        return name;
    }

    public void setTitle(String title) {
        this.name = title;
    }

    public String getContent() {
        return reply;
    }

    public void setContent(String content) {
        this.reply = content;
    }

    public String process(Match match) {
        try {
            return String.format("<action name='%s' reply='%s'></action>", name.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"), reply.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"));
        } catch (NullPointerException e) {
            return "";
        }
    }
}