package net.aihelp.core.util.elva.aiml;

import java.io.InputStream;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import net.aihelp.core.util.elva.Graphmaster;
import net.aihelp.core.util.elva.util.Searcher;
import net.aihelp.utils.TLog;

public class AIMLParser {

    private final Searcher searcher = new Searcher();
    private final AIMLHandler handler = new AIMLHandler();
    private SAXParser parser;

    public AIMLParser() throws AIMLParserConfigurationException {
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        } catch (Exception e) {
            throw new AIMLParserConfigurationException(e);
        }
    }

    public void parse(Graphmaster graphmaster, InputStream... sources) {
        try {
            for (InputStream aiml : sources) {
                parser.parse(aiml, handler);
            }
            graphmaster.append(handler.unload());
        } catch (Exception e) {
            // ignored
        }
    }
}