package net.aihelp.core.util.elva;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.aihelp.core.util.elva.aiml.Category;

public class Graphmaster {

    private final Map<String, Graphmaster> children = new HashMap<String, Graphmaster>();
    private int size = 0;
    private Graphmaster parent;
    private Category category;
    private String name; // The name of a node is the pattern element it represents.

    private Graphmaster(String name) {
        this.name = name;
    }

    public Graphmaster() {
    }

    public Graphmaster(List<Category> categories) {
        append(categories);
    }

    private void append(Category category, String[] elements, int index) {
        Graphmaster child = children.get(elements[index]);
        if (child == null) {
            appendChild(child = new Graphmaster(elements[index]));
        }

        int nextIndex = index + 1;
        if (elements.length <= nextIndex) {
            child.category = category;
        } else {
            child.append(category, elements, nextIndex);
        }
    }

    private void appendChild(Graphmaster child) {
        children.put(child.name, child);
        child.parent = this;
    }

    private Graphmaster[] children(String name) {
        return new Graphmaster[]{children.get("_"), children.get(name), children.get("*")};
    }

    private boolean isWildcard() {
        return ("_".equals(name) || "*".equals(name));
    }

    private Category match(Match match, int index) {
        if (isWildcard()) {
            return matchWildcard(match, index);
        }
        if (!name.equals(match.getMatchPath(index))) {
            return null;
        }
        int nextIndex = index + 1;
        if (match.getMatchPathLength() <= nextIndex) {
            return category;
        }
        return matchChildren(match, nextIndex);
    }

    private Category matchChildren(Match match, int nextIndex) {
        Graphmaster[] nodes = children(match.getMatchPath(nextIndex));
        for (int i = 0, n = nodes.length; i < n; i++) {
            Category category = (nodes[i] != null ? nodes[i].match(match, nextIndex) : null);
            if (category != null) {
                return category;
            }
        }
        return null;
    }

    private Category matchWildcard(Match match, int index) {
        int n = match.getMatchPathLength();
        for (int i = index; i < n; i++) {
            Category category = matchChildren(match, i);
            if (category != null) {
                match.appendWildcard(index, i);
                return category;
            }
        }
        if (category != null) {
            match.appendWildcard(index, n);
        }
        return category;
    }

    public void append(List<Category> categories) {
        for (Category category : categories) {
            append(category);
        }
    }

    public void append(Category category) {
        String[] matchPath = category.getMatchPath();
        append(category, matchPath, 0);
        size++;
    }

    public Category match(Match match) {
        return matchChildren(match, 0);
    }

    public int size() {
        return size;
    }
}