package net.aihelp.core.ui.loading.helper;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import net.aihelp.R;

import androidx.core.content.ContextCompat;

public class VaryViewHelperController {

    private Context mContext;
    private final VaryViewHelper helper;

    public VaryViewHelperController(View view) {
        this(new VaryViewHelper(view));
        mContext = view.getContext();
    }

    private VaryViewHelperController(VaryViewHelper helper) {
        this.helper = helper;
    }

    public void showLoading(String msg) {
        View layout = helper.inflate(R.layout.aihelp_layout_progress_loading);
        ProgressBar progressBar = layout.findViewById(R.id.aihelp_loading_progress);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            Drawable drawable = progressBar.getIndeterminateDrawable().mutate();
            drawable.setColorFilter(ContextCompat.getColor(mContext, R.color.aihelp_color_main), PorterDuff.Mode.SRC_IN);
            progressBar.setIndeterminateDrawable(drawable);
        }

        if (!TextUtils.isEmpty(msg)) {
            TextView textView = layout.findViewById(R.id.aihelp_loading_msg);
            textView.setText(msg);
        }
        helper.showLayout(layout);
    }

    public void showEmpty(int... layoutId) {
        if (layoutId != null && layoutId.length > 0) {
            View layout = helper.inflate(layoutId[0]);
            helper.showLayout(layout);
        }
    }

    public void showNetworkError() {
        View layout = helper.inflate(R.layout.aihelp_layout_network_err);
        helper.showLayout(layout);
    }

    public void restore() {
        helper.restoreView();
    }

}
