package net.aihelp.core.net.mqtt.tansport;

import net.aihelp.core.net.mqtt.hawtdispatch.Task;

import java.net.URI;
import java.security.NoSuchAlgorithmException;

import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

/**
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */

public class SslTransportServer extends TcpTransportServer {

    public static SslTransportServer createTransportServer(URI uri) throws Exception {
        return new SslTransportServer(uri);
    }

    protected KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    protected String protocol = "TLS";
    protected SSLContext sslContext;
    private String clientAuth = "want";
    private String disabledCypherSuites = null;

    public SslTransportServer(URI location) throws Exception {
        super(location);
        setSSLContext(SSLContext.getInstance(SslTransport.protocol(location.getScheme())));
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }
    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    public void start(Task onCompleted) throws Exception {
        if( keyManagers!=null ) {
            sslContext.init(keyManagers, trustManagers, null);
        } else {
            sslContext = SSLContext.getDefault();
        }
        super.start(onCompleted);
    }

    protected TcpTransport createTransport() {
        SslTransport rc = new SslTransport();
        rc.setDispatchQueue(dispatchQueue);
        rc.setBlockingExecutor(blockingExecutor);
        rc.setSSLContext(sslContext);
        rc.setClientAuth(clientAuth);
        rc.setDisabledCypherSuites(disabledCypherSuites);
        return rc;
    }

    public SslTransportServer protocol(String value) throws NoSuchAlgorithmException {
        this.protocol = value;
        sslContext = SSLContext.getInstance(protocol);
        return this;
    }

    public SSLContext getSSLContext() {
        return sslContext;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String getClientAuth() {
        return clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getDisabledCypherSuites() {
        return disabledCypherSuites;
    }

    public void setDisabledCypherSuites(String disabledCypherSuites) {
        this.disabledCypherSuites = disabledCypherSuites;
    }
}

