package net.aihelp.core.net.mqtt.tansport;

import net.aihelp.core.net.mqtt.hawtdispatch.CustomDispatchSource;
import net.aihelp.core.net.mqtt.hawtdispatch.Dispatch;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.EventAggregators;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.TaskWrapper;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

/**
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class PipeTransportServer implements TransportServer {

    protected String connectURI;
    protected TransportServerListener listener;
    protected String name;
    protected boolean marshal;
    protected final AtomicInteger connectionCounter = new AtomicInteger();
    DispatchQueue dispatchQueue;

    private CustomDispatchSource<PipeTransport, LinkedList<PipeTransport>> acceptSource;


    public String getBoundAddress() {
        return connectURI;
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public DispatchQueue getDispatchQueue() {
        return dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue queue) {
        dispatchQueue = queue;
    }

    public void suspend() {
        acceptSource.suspend();
    }

    public void resume() {
        acceptSource.resume();
    }

    public void setTransportServerListener(TransportServerListener listener) {
        this.listener = listener;
    }

    @Deprecated
    public void start(Runnable onCompleted) throws Exception {
        start(new TaskWrapper(onCompleted));
    }
    @Deprecated
    public void stop(Runnable onCompleted) throws Exception {
        stop(new TaskWrapper(onCompleted));
    }

    public void start(Task onCompleted) throws Exception {
        acceptSource = Dispatch.createSource(EventAggregators.<PipeTransport>linkedList(), dispatchQueue);
        acceptSource.setEventHandler(new Task() {
            public void run() {
                LinkedList<PipeTransport> transports = acceptSource.getData();
                for (PipeTransport transport : transports) {
                    try {
                        listener.onAccept(transport);
                    } catch (Exception e) {
                        listener.onAcceptError(e);
                    }
                }
            }
        });
        acceptSource.resume();
        if( onCompleted!=null ) {
            dispatchQueue.execute(onCompleted);
        }
    }

    public void stop(Task onCompleted) throws Exception {
        PipeTransportRegistry.unbind(this);
        acceptSource.setCancelHandler(onCompleted);
        acceptSource.cancel();
    }

    public void setConnectURI(String connectURI) {
        this.connectURI = connectURI;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public PipeTransport connect() {
        int connectionId = connectionCounter.incrementAndGet();
        String remoteAddress = connectURI.toString() + "#" + connectionId;

        PipeTransport clientTransport = createClientTransport();
        PipeTransport serverTransport = createServerTransport();
        clientTransport.peer = serverTransport;
        serverTransport.peer = clientTransport;

        clientTransport.setRemoteAddress(remoteAddress);
        serverTransport.setRemoteAddress(remoteAddress);

        serverTransport.setMarshal(marshal);
        this.acceptSource.merge(serverTransport);
        return clientTransport;
    }

    protected PipeTransport createClientTransport() {
        return new PipeTransport(this);
    }

    protected PipeTransport createServerTransport() {
        return new PipeTransport(this);
    }

    public boolean isMarshal() {
        return marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    public Executor getBlockingExecutor() {
        return null;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
    }
}
