package net.aihelp.core.net.mqtt.config;

import android.os.Build;
import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.utils.TLog;

import net.aihelp.core.net.mqtt.client.CallbackConnection;
import net.aihelp.core.net.mqtt.client.MQTT;
import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.client.Topic;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class MqttConfig {

    public static final int TYPE_ELVA_BOT = 1;
    public static final int TYPE_CONVERSATION = 2;
    public static final int TYPE_FAQ = 3; // just for avoid loading

    private boolean isConnected;
    private int loginType;
    private StringBuilder mqConfig = new StringBuilder();

    public int getLoginType() {
        return loginType;
    }

    public void setLoginType(int type) {
        this.loginType = type;
    }

    public boolean isConnected() {
        return isConnected;
    }

    public void setConnected(boolean connected) {
        isConnected = connected;
    }

    public CallbackConnection getMqttConnection(boolean isFaq) {
        MQTT mqtt = new MQTT();
        try {
            mqConfig = new StringBuilder();
            String ip = isFaq ? API.MQTT_FAQ_IP : API.MQTT_IP;
            int port = isFaq ? Integer.parseInt(TextUtils.isEmpty(API.MQTT_FAQ_PORT) ? "1883" : API.MQTT_FAQ_PORT) :
                    Integer.parseInt(TextUtils.isEmpty(API.MQTT_PORT) ? "1883" : API.MQTT_PORT);
            mqtt.setHost(ip, port);
            mqConfig.append(String.format("%s:%s, ", ip, port));

            mqtt.setWillQos(QoS.AT_MOST_ONCE);
            mqtt.setUserName(Const.APP_ID);
            mqtt.setPassword(md5(Const.APP_ID));
            mqConfig.append(String.format("userName:%s, pwd: %s, ", Const.APP_ID, md5(Const.APP_ID)));

            String clientId = "android_" + UUID.randomUUID();
            if (isFaq) {
                clientId = clientId + "_faq";
            }
            mqtt.setClientId(clientId);
            mqConfig.append(String.format("clientId:%s", clientId));

            mqtt.setConnectAttemptsMax(5);
            mqtt.setReconnectAttemptsMax(5);
            TLog.e("mqConfig: " + mqConfig.toString());
        } catch (Exception e) {
            AIHelpLogger.error("MqttConfig#getMqttConnection Exception", e);
        }
        return mqtt.callbackConnection();
    }

//    public Topic[] getTopic(boolean isFaq) {
//        String topicName = String.format("elva/%s/%s/%s/%s", API.MQTT_TOPIC,
//                Const.APP_ID, UserProfile.USER_ID, isFaq ? API.TOPIC_FAQ_NOTIFICATION : "+");
//        return new Topic[]{new Topic(topicName, QoS.AT_MOST_ONCE)};
//    }

    public Topic[] getTopic(boolean isFaq) {
        String topicName = String.format("elva/%s/%s/%s/%s", API.MQTT_TOPIC,
                Const.APP_ID, UserProfile.USER_ID, API.TOPIC_FAQ_NOTIFICATION);
        return !isFaq ? getNormalTopics() : new Topic[]{new Topic(topicName, QoS.AT_MOST_ONCE)};
    }

    private Topic[] getNormalTopics() {
        String[] topics = new String[]{
                API.TOPIC_LOGIN,
                API.TOPIC_LOGOUT,
                API.TOPIC_BOT_CHAT,
                API.TOPIC_BOT_FAQ,
                API.TOPIC_CONVERSATION_SEND,
                API.TOPIC_CONVERSATION_RECEIVE,
                API.TOPIC_CONVERSATION_FINISHED,
                API.TOPIC_CONVERSATION_EVALUATE,
                API.TOPIC_SUBMIT_FORM,
                API.TOPIC_WITHDRAW,
        };

        Topic[] t = new Topic[topics.length];
        for (int i = 0; i < topics.length; i++) {
            String topicName = String.format("elva/%s/%s/%s/%s", API.MQTT_TOPIC,
                    Const.APP_ID, UserProfile.USER_ID, topics[i]);
            t[i] = new Topic(topicName, QoS.AT_MOST_ONCE);
        }
        return t;
    }

    public static String newTopic(String topic) {
        return String.format("%s/%s/%s/%s", API.MQTT_TOPIC, Const.APP_ID, UserProfile.USER_ID, topic);
    }

    private String md5(String string) {
        if (!TextUtils.isEmpty(string)) {
            byte[] hash = new byte[0];
            try {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                    hash = MessageDigest.getInstance("MD5").digest(string.getBytes(StandardCharsets.UTF_8));
                }
            } catch (NoSuchAlgorithmException e) {
                TLog.e("RuntimeException Huh, MD5 should be supported? " + e.toString());
                return string;
            }
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 0x10) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            return hex.toString();
        }
        return "";
    }

    public String getMqConfig() {
        return mqConfig.toString();
    }

    private MqttConfig() {
    }

    public static MqttConfig getInstance() {
        return MqttConfig.Holder.INSTANCE;
    }

    private static class Holder {
        private static final MqttConfig INSTANCE = new MqttConfig();
    }
}
