package net.aihelp.core.net.mqtt.codec;

import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayInputStream;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayOutputStream;

import java.io.IOException;
import java.net.ProtocolException;
import net.aihelp.core.net.mqtt.codec.MessageSupport.*;

/**
 * <p>
 * </p>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class PUBREL extends MessageSupport.HeaderBase implements Message, Acked {

    public static final byte TYPE = 6;

    private short messageId;

    public byte messageType() {
        return TYPE;
    }

    public PUBREL() {
        qos(QoS.AT_LEAST_ONCE);
    }

    public PUBREL decode(MQTTFrame frame) throws ProtocolException {
        header(frame.header());
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        messageId = is.readShort();
        return this;
    }

    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream(2);
            os.writeShort(messageId);

            MQTTFrame frame = new MQTTFrame();
            frame.header(header());
            frame.commandType(TYPE);
            return frame.buffer(os.toBuffer());
        } catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }


    @Override
    public boolean dup() {
        return super.dup();
    }

    @Override
    public PUBREL dup(boolean dup) {
        return (PUBREL) super.dup(dup);
    }

    @Override
    public QoS qos() {
        return super.qos();
    }

    public short messageId() {
        return messageId;
    }

    public PUBREL messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    @Override
    public String toString() {
        return "PUBREL{" +
                "dup=" + dup() +
                ", qos=" + qos() +
                ", messageId=" + messageId +
                '}';
    }
}
