package net.aihelp.core.net.mqtt.callback;

import net.aihelp.common.API;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.ui.helper.MessageSyncHelper;
import net.aihelp.ui.helper.LoginMqttHelper;

import net.aihelp.core.net.mqtt.client.Callback;

public class SubscribeCallback implements Callback<byte[]> {

    private boolean isFaqRequest;
    private AIHelpMqtt aiHelpMqtt;
    private IMqttCallback mqttCallback;

    public SubscribeCallback(boolean isFaqRequest, AIHelpMqtt mqtt, IMqttCallback callback) {
        this.isFaqRequest = isFaqRequest;
        aiHelpMqtt = mqtt;
        mqttCallback = callback;
    }

    @Override
    public void onSuccess(byte[] value) {
        if (!isFaqRequest && aiHelpMqtt != null && MqttConfig.getInstance().isConnected()) {
            aiHelpMqtt.postToServer(API.TOPIC_LOGIN, LoginMqttHelper.getLoginParams());
        }
    }

    @Override
    public void onFailure(final Throwable value) {
        AIHelpLogger.error("mqtt subscribe failure", value);
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (mqttCallback != null) {
                    mqttCallback.onMqttFailure("SubscribeCallback " + value.getMessage());
                }
            }
        });
    }

}
