package net.aihelp.core.net.mqtt.callback;

import android.os.Handler;

import net.aihelp.common.API;
import net.aihelp.common.IntentValues;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.client.CallbackConnection;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.utils.TLog;

import net.aihelp.core.net.mqtt.hawtbuf.Buffer;
import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;
import net.aihelp.core.net.mqtt.client.Listener;

public class ReceiveListener implements Listener {

    private final Handler handler;
    private final IMqttCallback callback;

    public ReceiveListener(IMqttCallback callback, Handler handler) {
        this.callback = callback;
        this.handler = handler;
    }

    @Override
    public void onConnected() {
        callback.onMqttConnected();
    }

    @Override
    public void onDisconnected() {

    }

    @Override
    public void onPublish(UTF8Buffer utf8Buffer, Buffer body, Runnable ack) {
        if (callback != null) {
            String[] topicArr = utf8Buffer.toString().split("/");
            final String topic = topicArr[topicArr.length - 1];
            String response = new String(body.toByteArray()).trim();

            if (API.TOPIC_LOGIN.equals(topic) && handler != null) {
                handler.removeCallbacksAndMessages(null);
            }

            TLog.json(String.format("MQTT %s [onResponse] %s",
                    this.toString().replace(this.getClass().getName(),
                            this.getClass().getSimpleName()), topic), response);
            final String finalResponse = response;
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    callback.onMqttResponse(MqttConfig.getInstance().getLoginType(), topic, finalResponse);
                }
            });
        }
        ack.run();
    }

    @Override
    public void onFailure(final Throwable value) {
        MqttConfig.getInstance().setConnected(false);
        AIHelpLogger.error("ReceiveListener onFailure", value);
    }

}

