package net.aihelp.core.net.mqtt.callback;

import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.ui.helper.MessageSyncHelper;

import net.aihelp.core.net.mqtt.client.Callback;

public class ConnectCallback implements Callback<Void> {

    private final boolean isFaq;
    private final IMqttCallback callback;

    public ConnectCallback(boolean isFaq, IMqttCallback callback) {
        this.isFaq = isFaq;
        this.callback = callback;
    }

    @Override
    public void onSuccess(Void value) {
        if (isFaq) return;
        MqttConfig.getInstance().setConnected(true);
    }

    @Override
    public void onFailure(final Throwable value) {
        AIHelpLogger.error("mqtt connect failure", value);
        if (isFaq) return;
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (callback != null) {
                    callback.onMqttFailure("ConnectCallback " + value.getMessage());
                }
            }
        });
    }

}
