package net.aihelp.core.net.http.interceptor;

import android.text.TextUtils;

import net.aihelp.common.Const;
import net.aihelp.core.net.http.config.HttpConfig;
import net.aihelp.utils.TLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Pattern;

import androidx.annotation.NonNull;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;

public class HeaderInterceptor implements Interceptor {

    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Request request = chain.request();
        try {
            RequestBody requestBody = request.body();
            if (request.method().equals("GET")) {
                String sUrl = request.url().toString();
                if (!sUrl.contains(".ini") && !sUrl.contains(".json") && !sUrl.contains(".aiml")) {
                    int index = sUrl.indexOf("?");
                    if (index > 0) {
                        sUrl = sUrl + "&";
                    } else {
                        sUrl = sUrl + "?";
                    }
                    sUrl = sUrl + getAppendedParams();
                    request = request.newBuilder().url(sUrl).build();   //重新构建
                }
            } else if (request.method().equals("POST")) {
                if (requestBody instanceof FormBody) {
                    FormBody.Builder builder = new FormBody.Builder();
                    FormBody formBody = (FormBody) requestBody;
                    for (int i = 0; i < formBody.size(); i++) {    // 如果要对已有的参数做进一步处理可以这样拿到参数
                        builder.addEncoded(formBody.encodedName(i), formBody.encodedValue(i));
                    }
                    builder.addEncoded("appId", Const.APP_ID);  //添加公共参数
//                    builder.addEncoded("appkey", Const.APP_KEY);
                    builder.addEncoded("lan", Const.TARGET_LAN);
                    builder.addEncoded("l", Const.TARGET_LAN);
                    builder.addEncoded("platform", String.valueOf(Const.SDK_PLATFORM));
                    builder.addEncoded("sdkVersion", Const.SDK_VERSION);
                    builder.addEncoded("sdkVersionDetail", Const.SDK_VERSION);
                    request = request.newBuilder().post(builder.build()).build();  //重新构建
                    return chain.proceed(request);
                }

                MediaType mediaType = null;
                if (request.body() != null) {
                    mediaType = request.body().contentType();
                }
                if (mediaType != null && "json".equals(mediaType.subtype())) {
                    String postJson = bodyToString(request.body());
                    if (!TextUtils.isEmpty(postJson)) {
                        try {
                            new JSONArray(postJson);
                        } catch (Exception e) {
                            JSONObject jsonObject = new JSONObject(postJson);
                            jsonObject.put("appId", Const.APP_ID);  //添加公共参数
//                            jsonObject.put("appkey", Const.APP_KEY);
                            jsonObject.put("lan", Const.TARGET_LAN);
                            jsonObject.put("l", Const.TARGET_LAN);
                            jsonObject.put("platform", Const.SDK_PLATFORM);
                            jsonObject.put("sdkVersion", Const.SDK_VERSION);
                            jsonObject.put("sdkVersionDetail", Const.SDK_VERSION);
                            RequestBody newBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"),
                                    jsonObject.toString());
                            request = request.newBuilder().post(newBody).build();
                        }
                    }
                } else {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("appId", Const.APP_ID);  //添加公共参数
//                    jsonObject.put("appkey", Const.APP_KEY);
                    jsonObject.put("lan", Const.TARGET_LAN);
                    jsonObject.put("l", Const.TARGET_LAN);
                    jsonObject.put("platform", Const.SDK_PLATFORM);
                    jsonObject.put("sdkVersion", Const.SDK_VERSION);
                    jsonObject.put("sdkVersionDetail", Const.SDK_VERSION);
                    RequestBody newBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"),
                            jsonObject.toString());
                    request = request.newBuilder().post(newBody).build();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return chain.proceed(request);
    }

    private String getAppendedParams() {
        return String.format("appId=%s&l=%s&lan=%s&platform=%s&sdkVersion=%s&sdkVersionDetail=%s",
                Const.APP_ID, Const.TARGET_LAN, Const.TARGET_LAN, Const.SDK_PLATFORM,
                Const.SDK_VERSION, Const.SDK_VERSION);
    }

    private String bodyToString(final RequestBody request) {
        try {
            final Buffer buffer = new Buffer();
            if (request != null)
                request.writeTo(buffer);
            else
                return "";
            return buffer.readUtf8();
        } catch (final IOException e) {
            return "";
        }
    }


}
