package net.aihelp.core.net.http.callback;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.utils.TLog;

public abstract class ReqCallback<T> extends BaseCallback<T> {

    @Override
    public void onFailure(String url, int errorCode, String errorMsg) {
        TLog.e("ReqCallback onFailure: " + url + " <-> " + errorCode + " <-> " + errorMsg);
        AIHelpLogger.error(url, new UnknownError(errorMsg));
        if (onFailure(errorCode, errorMsg) || errorCode != 200) {
            if (AIHelpContext.getInstance().getContext() != null) {
//                Toast.makeText(AIHelpContext.getInstance().getContext(),
//                        String.format("[%s] - [%s]", errorCode, errorMsg), Toast.LENGTH_LONG).show();
            }
        }
    }

    public boolean onFailure(int errorCode, String errorMsg) {
        return true;
    }

    @Override
    public void onReqSuccess(T result) {

    }

    @Override
    public void onAsyncReqSuccess(T result) {

    }

    @Override
    public void onAsyncFailure(String url, int errorCode, String errorMsg) {

    }

}
