package net.aihelp.core.net.http.callback;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;

public abstract class BaseCallback<T> {

    private Type type;

    private String requestUrl;

    private HashMap<String, String> paramsMap;

    public String getRequestUrl() {
        return requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public HashMap<String, String> getParamsMap() {
        return paramsMap;
    }

    public void setParamsMap(HashMap<String, String> paramsMap) {
        this.paramsMap = paramsMap;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public BaseCallback() {
        Type superClass = getClass().getGenericSuperclass();
        type = ((ParameterizedType) superClass).getActualTypeArguments()[0];
        if (type == null) {
            throw new IllegalArgumentException("ReqCallBack must have a generic type!");
        }
    }

    public abstract void onReqSuccess(T result);
    public abstract void onAsyncReqSuccess(T result);

    public abstract void onFailure(String url, int errorCode, String errorMsg);
    public abstract void onAsyncFailure(String url, int errorCode, String errorMsg);

}
