package net.aihelp.core.net.http;

import net.aihelp.utils.TLog;

import java.io.File;
import java.io.IOException;

import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class FileProgressRequestBody extends RequestBody {

    public interface ProgressListener {
        void onProgress(int progress, boolean isDone);
    }

    private static final int SEGMENT_SIZE = 2 * 1024;

    protected File file;
    protected ProgressListener listener;
    private MediaType mediaType;

    public FileProgressRequestBody(MediaType mediaType, File file, ProgressListener listener) {
        this.mediaType = mediaType;
        this.file = file;
        this.listener = listener;
    }

    @Override
    public long contentLength() {
        return file.length();
    }

    @Override
    public MediaType contentType() {
        return mediaType;
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source(file);

            long transferred = 0;
            long read;

            while ((read = source.read(sink.buffer(), SEGMENT_SIZE)) != -1) {
                transferred += read;
                sink.flush();
                if (listener != null) {
                    listener.onProgress((int) (transferred * 100 / contentLength()), transferred == contentLength());
                }
            }

        } finally {
            Util.closeQuietly(source);
        }
    }

}
