package net.aihelp.core.mvp;

import android.content.Context;
import android.text.TextUtils;

import net.aihelp.BuildConfig;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.utils.SpUtil;

import java.lang.reflect.Field;

public abstract class AbsRepository implements IRepository {

    protected Context mContext;
    protected SpUtil mSp;

    public AbsRepository(Context context) {
        this.mContext = context;
        mSp = SpUtil.getInstance();
    }

    protected void doSave(String key, Object value) {
        mSp.put(key, value);
    }

    protected void updateUserProfile(String field, String update) {
        updateValue(UserProfile.class, field, update);
    }

    protected void updateAPI(String field, String update) {
        if (TextUtils.isEmpty(update)) return;
        updateValue(API.class, field, update);
    }

    protected void updateConst(String field, Object update) {
        updateValue(Const.class, field, update);
    }

    private void updateValue(Class clazz, String field, Object update) {
        try {
            String[] split = field.split("\\.");
            Field originField = clazz.getDeclaredField(split[1]);
            originField.setAccessible(true);
            if (update != null) {
                originField.set(null, update);
            } else if ("String".equals(originField.getType().getSimpleName())) {
                originField.set(null, "");
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (BuildConfig.DEBUG) {
                throw new RuntimeException("updateValue failed, cause " + e.toString());
            }
        }
    }

}
