/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.time;

import net.aholbrook.paseto.time.Clock;
import net.aholbrook.paseto.time.Duration;
import net.aholbrook.paseto.time.temporal.ChronoUnit;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalUnit;

public class OffsetDateTime {
    private final org.threeten.bp.OffsetDateTime offsetDateTime;

    public OffsetDateTime(org.threeten.bp.OffsetDateTime offsetDateTime) {
        this.offsetDateTime = offsetDateTime;
    }

    public org.threeten.bp.OffsetDateTime raw() {
        return this.offsetDateTime;
    }

    public static OffsetDateTime now() {
        return new OffsetDateTime(org.threeten.bp.OffsetDateTime.now());
    }

    public static OffsetDateTime now(Clock systemUTC) {
        return new OffsetDateTime(org.threeten.bp.OffsetDateTime.now((org.threeten.bp.Clock)systemUTC.raw()));
    }

    public OffsetDateTime truncatedTo(ChronoUnit seconds) {
        return new OffsetDateTime(this.offsetDateTime.truncatedTo((TemporalUnit)seconds.raw()));
    }

    public OffsetDateTime plus(Duration d) {
        return new OffsetDateTime(this.offsetDateTime.plus((TemporalAmount)d.raw()));
    }

    public OffsetDateTime minus(Duration d) {
        return new OffsetDateTime(this.offsetDateTime.minus((TemporalAmount)d.raw()));
    }

    public boolean isBefore(OffsetDateTime time) {
        return this.offsetDateTime.isBefore(time.raw());
    }

    public boolean isAfter(OffsetDateTime time) {
        return this.offsetDateTime.isAfter(time.raw());
    }

    public OffsetDateTime plusSeconds(int l) {
        return new OffsetDateTime(this.offsetDateTime.plusSeconds((long)l));
    }

    public OffsetDateTime minusSeconds(long l) {
        return new OffsetDateTime(this.offsetDateTime.minusSeconds(l));
    }

    public OffsetDateTime plusMinutes(long l) {
        return new OffsetDateTime(this.offsetDateTime.plusMinutes(l));
    }

    public OffsetDateTime minusMinutes(long l) {
        return new OffsetDateTime(this.offsetDateTime.minusMinutes(l));
    }

    public long toEpochSecond() {
        return this.offsetDateTime.toEpochSecond();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetDateTime that = (OffsetDateTime)o;
        return this.offsetDateTime.equals((Object)that.offsetDateTime);
    }

    public int hashCode() {
        return this.offsetDateTime.hashCode();
    }

    public String toString() {
        return this.offsetDateTime.toString();
    }

    public static OffsetDateTime ofEpochSecond(long l) {
        return new OffsetDateTime(org.threeten.bp.OffsetDateTime.ofInstant((Instant)Instant.ofEpochSecond((long)l), (ZoneId)ZoneId.of((String)"UTC")));
    }

    public OffsetDateTime plusDays(long l) {
        return new OffsetDateTime(this.offsetDateTime.plusDays(l));
    }
}

