/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import net.aholbrook.paseto.crypto.exception.ByteArrayLengthException;
import net.aholbrook.paseto.crypto.exception.ByteArrayRangeException;
import net.aholbrook.paseto.crypto.v2.V2CryptoProvider;
import net.aholbrook.paseto.test.data.RfcTestVectors;
import net.aholbrook.paseto.test.utils.AssertUtils;
import net.aholbrook.paseto.test.utils.TestContext;
import org.junit.Assert;
import org.junit.Test;

public class V2CryptoProviderTest {
    private static final byte[] BLAKE2B_OUT = new byte[16];
    private static final byte[] BLAKE2B_IN = new byte[]{1, 2, 3, 4, 5, 6};
    private static final byte[] BLAKE2B_KEY = new byte[16];
    private static final byte[] XCHACHA20_POLY1305_IETF_IN = new byte[6];
    private static final byte[] XCHACHA20_POLY1305_IETF_OUT = new byte[16 + XCHACHA20_POLY1305_IETF_IN.length];
    private static final byte[] XCHACHA20_POLY1305_IETF_IN_DECRYPT = XCHACHA20_POLY1305_IETF_OUT;
    private static final byte[] XCHACHA20_POLY1305_IETF_OUT_DECRYPT = XCHACHA20_POLY1305_IETF_IN;
    private static final byte[] XCHACHA20_POLY1305_IETF_AD = new byte[6];
    private static final byte[] XCHACHA20_POLY1305_IETF_NONCE = new byte[24];
    private static final byte[] XCHACHA20_POLY1305_IETF_KEY = new byte[6];
    private static final byte[] ED25519S_SIG = new byte[64];
    private static final byte[] ED25519S_M = new byte[6];
    private static final byte[] ED25519S_SK = new byte[64];
    private static final byte[] ED25519S_PK = new byte[32];

    private V2CryptoProvider v2CryptoProvider() {
        return TestContext.builders().v2CryptoProvider();
    }

    @Test
    public void crypto_v2_randomBytes() {
        byte[] r1 = this.v2CryptoProvider().randomBytes(24);
        byte[] r2 = this.v2CryptoProvider().randomBytes(24);
        AssertUtils.assertNotEquals(r1, r2);
    }

    @Test
    public void crypto_v2_nonce() {
        Assert.assertNotNull((Object)this.v2CryptoProvider().getNonceGenerator());
        byte[] r1 = this.v2CryptoProvider().getNonceGenerator().generateNonce();
        byte[] r2 = this.v2CryptoProvider().getNonceGenerator().generateNonce();
        AssertUtils.assertNotEquals(r1, r2);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_blake2b_nullOut() {
        this.v2CryptoProvider().blake2b(null, BLAKE2B_IN, BLAKE2B_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_blake2b_nullIn() {
        this.v2CryptoProvider().blake2b(BLAKE2B_OUT, null, BLAKE2B_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_blake2b_nullKey() {
        this.v2CryptoProvider().blake2b(BLAKE2B_OUT, BLAKE2B_IN, null);
    }

    @Test(expected=ByteArrayRangeException.class)
    public void crypto_v2_blake2b_outShort() {
        AssertUtils.assertByteArrayRangeException(() -> this.v2CryptoProvider().blake2b(new byte[15], BLAKE2B_IN, BLAKE2B_KEY), "out", 15, 16, 64);
    }

    @Test(expected=ByteArrayRangeException.class)
    public void crypto_v2_blake2b_outLong() {
        AssertUtils.assertByteArrayRangeException(() -> this.v2CryptoProvider().blake2b(new byte[65], BLAKE2B_IN, BLAKE2B_KEY), "out", 65, 16, 64);
    }

    @Test(expected=ByteArrayRangeException.class)
    public void crypto_v2_blake2b_keyShort() {
        AssertUtils.assertByteArrayRangeException(() -> this.v2CryptoProvider().blake2b(BLAKE2B_OUT, BLAKE2B_IN, new byte[15]), "key", 15, 16, 64);
    }

    @Test(expected=ByteArrayRangeException.class)
    public void crypto_v2_blake2b_keyLong() {
        AssertUtils.assertByteArrayRangeException(() -> this.v2CryptoProvider().blake2b(BLAKE2B_OUT, BLAKE2B_IN, new byte[65]), "key", 65, 16, 64);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_nullOut() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(null, XCHACHA20_POLY1305_IETF_IN, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_nullIn() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, null, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_nullAd() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, XCHACHA20_POLY1305_IETF_IN, null, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_nullNonce() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, XCHACHA20_POLY1305_IETF_IN, XCHACHA20_POLY1305_IETF_AD, null, XCHACHA20_POLY1305_IETF_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_nullKey() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, XCHACHA20_POLY1305_IETF_IN, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_shortOut() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(new byte[XCHACHA20_POLY1305_IETF_OUT.length - 1], XCHACHA20_POLY1305_IETF_IN, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY), "out", XCHACHA20_POLY1305_IETF_OUT.length - 1, XCHACHA20_POLY1305_IETF_OUT.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_longOut() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(new byte[XCHACHA20_POLY1305_IETF_OUT.length + 1], XCHACHA20_POLY1305_IETF_IN, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY), "out", XCHACHA20_POLY1305_IETF_OUT.length + 1, XCHACHA20_POLY1305_IETF_OUT.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_shortIn() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, new byte[0], XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY), "in", 0, 1, false);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_shortAd() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, XCHACHA20_POLY1305_IETF_IN, new byte[0], XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY), "ad", 0, 1, false);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_shortNonce() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, XCHACHA20_POLY1305_IETF_IN, XCHACHA20_POLY1305_IETF_AD, new byte[XCHACHA20_POLY1305_IETF_NONCE.length - 1], XCHACHA20_POLY1305_IETF_KEY), "nonce", XCHACHA20_POLY1305_IETF_NONCE.length - 1, XCHACHA20_POLY1305_IETF_NONCE.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_longNonce() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, XCHACHA20_POLY1305_IETF_IN, XCHACHA20_POLY1305_IETF_AD, new byte[XCHACHA20_POLY1305_IETF_NONCE.length + 1], XCHACHA20_POLY1305_IETF_KEY), "nonce", XCHACHA20_POLY1305_IETF_NONCE.length + 1, XCHACHA20_POLY1305_IETF_NONCE.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfEncrypt_shortKey() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfEncrypt(XCHACHA20_POLY1305_IETF_OUT, XCHACHA20_POLY1305_IETF_IN, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, new byte[0]), "key", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfDecrypt_nullOut() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfDecrypt(null, XCHACHA20_POLY1305_IETF_IN_DECRYPT, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfDecrypt_nullIn() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfDecrypt(XCHACHA20_POLY1305_IETF_OUT_DECRYPT, null, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfDecrypt_nullAd() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfDecrypt(XCHACHA20_POLY1305_IETF_OUT_DECRYPT, XCHACHA20_POLY1305_IETF_IN_DECRYPT, null, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfDecrypt_nullNonce() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfDecrypt(XCHACHA20_POLY1305_IETF_OUT_DECRYPT, XCHACHA20_POLY1305_IETF_IN_DECRYPT, XCHACHA20_POLY1305_IETF_AD, null, XCHACHA20_POLY1305_IETF_KEY);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfDecrypt_nullKey() {
        this.v2CryptoProvider().aeadXChaCha20Poly1305IetfDecrypt(XCHACHA20_POLY1305_IETF_OUT_DECRYPT, XCHACHA20_POLY1305_IETF_IN_DECRYPT, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfDecrypt_shortOut() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfDecrypt(new byte[XCHACHA20_POLY1305_IETF_OUT_DECRYPT.length - 1], XCHACHA20_POLY1305_IETF_IN_DECRYPT, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY), "out", XCHACHA20_POLY1305_IETF_OUT_DECRYPT.length - 1, XCHACHA20_POLY1305_IETF_OUT_DECRYPT.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfDecrypt_longOut() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfDecrypt(new byte[XCHACHA20_POLY1305_IETF_OUT_DECRYPT.length + 1], XCHACHA20_POLY1305_IETF_IN_DECRYPT, XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY), "out", XCHACHA20_POLY1305_IETF_OUT_DECRYPT.length + 1, XCHACHA20_POLY1305_IETF_OUT_DECRYPT.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_aeadXChaCha20Poly1305IetfDecrypt_shortIn() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().aeadXChaCha20Poly1305IetfDecrypt(XCHACHA20_POLY1305_IETF_OUT_DECRYPT, new byte[0], XCHACHA20_POLY1305_IETF_AD, XCHACHA20_POLY1305_IETF_NONCE, XCHACHA20_POLY1305_IETF_KEY), "in", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_ed25519Sign_nullSig() {
        this.v2CryptoProvider().ed25519Sign(null, ED25519S_M, ED25519S_SK);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_ed25519Sign_nullM() {
        this.v2CryptoProvider().ed25519Sign(ED25519S_SIG, null, ED25519S_SK);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_ed25519Sign_nullSk() {
        this.v2CryptoProvider().ed25519Sign(ED25519S_SIG, ED25519S_M, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Sign_shortSig() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Sign(new byte[ED25519S_SIG.length - 1], ED25519S_M, ED25519S_SK), "sig", ED25519S_SIG.length - 1, ED25519S_SIG.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Sign_longSig() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Sign(new byte[ED25519S_SIG.length + 1], ED25519S_M, ED25519S_SK), "sig", ED25519S_SIG.length + 1, ED25519S_SIG.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Sign_shortM() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Sign(ED25519S_SIG, new byte[0], ED25519S_SK), "m", 0, 1, false);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Sign_shortSk() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Sign(ED25519S_SIG, ED25519S_M, new byte[ED25519S_SK.length - 1]), "sk", ED25519S_SK.length - 1, ED25519S_SK.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Sign_longSk() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Sign(ED25519S_SIG, ED25519S_M, new byte[ED25519S_SK.length + 1]), "sk", ED25519S_SK.length + 1, ED25519S_SK.length, true);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_ed25519Verify_nullSig() {
        this.v2CryptoProvider().ed25519Verify(null, ED25519S_M, ED25519S_PK);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_ed25519Verify_nullM() {
        this.v2CryptoProvider().ed25519Verify(ED25519S_SIG, null, ED25519S_PK);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_ed25519Verify_nullPk() {
        this.v2CryptoProvider().ed25519Verify(ED25519S_SIG, ED25519S_M, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Verify_shortSig() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Verify(new byte[ED25519S_SIG.length - 1], ED25519S_M, ED25519S_PK), "sig", ED25519S_SIG.length - 1, ED25519S_SIG.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Verify_longSig() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Verify(new byte[ED25519S_SIG.length + 1], ED25519S_M, ED25519S_PK), "sig", ED25519S_SIG.length + 1, ED25519S_SIG.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Verify_shortM() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Verify(ED25519S_SIG, new byte[0], ED25519S_PK), "m", 0, 1, false);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Verify_shortPk() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Verify(ED25519S_SIG, ED25519S_M, new byte[ED25519S_PK.length - 1]), "pk", ED25519S_PK.length - 1, ED25519S_PK.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519Verify_longPk() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519Verify(ED25519S_SIG, ED25519S_M, new byte[ED25519S_PK.length + 1]), "pk", ED25519S_PK.length + 1, ED25519S_PK.length, true);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v2_ed25519PublicKey_nullSk() {
        this.v2CryptoProvider().ed25519SkToPk(null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519PublicKey_shortSk() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519SkToPk(new byte[ED25519S_SK.length - 1]), "sk", ED25519S_SK.length - 1, ED25519S_SK.length, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v2_ed25519PublicKey_longSk() {
        AssertUtils.assertByteArrayLengthException(() -> this.v2CryptoProvider().ed25519SkToPk(new byte[ED25519S_SK.length + 1]), "sk", ED25519S_SK.length + 1, ED25519S_SK.length, true);
    }

    @Test
    public void crypto_v2_ed25519PublicKey() {
        byte[] pk = this.v2CryptoProvider().ed25519SkToPk(RfcTestVectors.RFC_TEST_SK);
        AssertUtils.assertEquals(RfcTestVectors.RFC_TEST_PK, pk);
    }
}

