/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import net.aholbrook.paseto.exception.Pkcs12LoadException;
import net.aholbrook.paseto.util.Pkcs12;
import org.junit.Assert;
import org.junit.Test;

public class Pkcs12Test {
    private static void assertPkcs12LoadException(Pkcs12LoadException e, Pkcs12LoadException.Reason reason) {
        Assert.assertEquals((String)"reason", (Object)reason, (Object)e.getReason());
        throw e;
    }

    @Test
    public void pkcs12_load() {
        System.out.println("dir: " + System.getProperty("user.dir"));
        Pkcs12.load((String)"../test/p12/rfc_v1_rsa.p12", (String)"testtest", (String)"test");
    }

    @Test
    public void pkcs12_load2() {
        Pkcs12.load((String)"../test/p12/test_v1_rsa.p12", (String)"password", (String)"test", (String)"password");
    }

    @Test(expected=Pkcs12LoadException.class)
    public void pkcs12_loadNotFound() {
        try {
            Pkcs12.load((String)"../test/p12/notafile.p12", (String)"testtest", (String)"test", (String)"testtest");
        }
        catch (Pkcs12LoadException e) {
            Pkcs12Test.assertPkcs12LoadException(e, Pkcs12LoadException.Reason.FILE_NOT_FOUND);
        }
    }

    @Test(expected=Pkcs12LoadException.class)
    public void pkcs12_loadWrongPassword() {
        try {
            Pkcs12.load((String)"../test/p12/rfc_v1_rsa.p12", (String)"wrong", (String)"test", (String)"testtest");
        }
        catch (Pkcs12LoadException e) {
            Pkcs12Test.assertPkcs12LoadException(e, Pkcs12LoadException.Reason.INCORRECT_PASSWORD);
        }
    }

    @Test(expected=Pkcs12LoadException.class)
    public void pkcs12_loadWrongAlias() {
        try {
            Pkcs12.load((String)"../test/p12/rfc_v1_rsa.p12", (String)"testtest", (String)"wrong", (String)"testtest");
        }
        catch (Pkcs12LoadException e) {
            Pkcs12Test.assertPkcs12LoadException(e, Pkcs12LoadException.Reason.PRIVATE_KEY_NOT_FOUND);
        }
    }

    @Test(expected=Pkcs12LoadException.class)
    public void pkcs12_loadWrongKeyPass() {
        try {
            Pkcs12.load((String)"../test/p12/rfc_v1_rsa.p12", (String)"testtest", (String)"test", (String)"wrong");
        }
        catch (Pkcs12LoadException e) {
            Pkcs12Test.assertPkcs12LoadException(e, Pkcs12LoadException.Reason.UNRECOVERABLE_KEY);
        }
    }

    @Test(expected=Pkcs12LoadException.class)
    public void pkcs12_loadNoCertificate() {
        try {
            Pkcs12.load((String)"../test/p12/test_v1_rsa_nopub.p12", (String)"password", (String)"test", (String)"password");
        }
        catch (Pkcs12LoadException e) {
            Pkcs12Test.assertPkcs12LoadException(e, Pkcs12LoadException.Reason.PUBLIC_KEY_NOT_FOUND);
        }
    }

    @Test(expected=Pkcs12LoadException.class)
    public void pkcs12_loadCorrupt() {
        try {
            Pkcs12.load((String)"../test/p12/test_v1_rsa_corrupt.p12", (String)"password", (String)"test", (String)"password");
        }
        catch (Pkcs12LoadException e) {
            Pkcs12Test.assertPkcs12LoadException(e, Pkcs12LoadException.Reason.IO_EXCEPTION);
        }
    }

    @Test
    public void pkcs12_exceptions() {
        try {
            Pkcs12Test.assertPkcs12LoadException(new Pkcs12LoadException(new NoSuchAlgorithmException()), Pkcs12LoadException.Reason.ALGORITHM_NOT_FOUND);
        }
        catch (Pkcs12LoadException pkcs12LoadException) {
            // empty catch block
        }
        try {
            Pkcs12Test.assertPkcs12LoadException(new Pkcs12LoadException(new CertificateException()), Pkcs12LoadException.Reason.CERTIFICATE_ERROR);
        }
        catch (Pkcs12LoadException pkcs12LoadException) {
            // empty catch block
        }
    }
}

