/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import java.time.Duration;
import java.time.OffsetDateTime;
import net.aholbrook.paseto.Paseto;
import net.aholbrook.paseto.PasetoV2;
import net.aholbrook.paseto.TokenWithFooter;
import net.aholbrook.paseto.claims.Claim;
import net.aholbrook.paseto.claims.CurrentlyValid;
import net.aholbrook.paseto.exception.claims.MissingClaimException;
import net.aholbrook.paseto.service.KeyId;
import net.aholbrook.paseto.service.LocalTokenService;
import net.aholbrook.paseto.service.PublicTokenService;
import net.aholbrook.paseto.service.Token;
import net.aholbrook.paseto.service.TokenService;
import net.aholbrook.paseto.test.PasetoServiceTest;
import net.aholbrook.paseto.test.data.RfcTestVectors;
import net.aholbrook.paseto.test.data.RfcToken;
import net.aholbrook.paseto.test.data.TestVector;
import net.aholbrook.paseto.test.data.TokenTestVectors;
import net.aholbrook.paseto.test.utils.AssertUtils;
import net.aholbrook.paseto.test.utils.TestContext;
import org.junit.Assert;
import org.junit.Test;

public class PasetoV2ServiceTest
extends PasetoServiceTest {
    private static LocalTokenService.KeyProvider rfcLocalKeyProvider() {
        return () -> RfcTestVectors.RFC_TEST_KEY;
    }

    private static PublicTokenService.KeyProvider rfcPublicKeyProvider() {
        return new PublicTokenService.KeyProvider(){

            public byte[] getSecretKey() {
                return RfcTestVectors.RFC_TEST_SK;
            }

            public byte[] getPublicKey() {
                return RfcTestVectors.RFC_TEST_PK;
            }
        };
    }

    private static LocalTokenService.KeyProvider tokenLocalKeyProvider() {
        return () -> TokenTestVectors.TEST_KEY;
    }

    private static PublicTokenService.KeyProvider tokenPublicKeyProvider() {
        return new PublicTokenService.KeyProvider(){

            public byte[] getSecretKey() {
                return TokenTestVectors.TEST_SK;
            }

            public byte[] getPublicKey() {
                return TokenTestVectors.TEST_PK;
            }
        };
    }

    private static TokenService<RfcToken> rfcLocalService(byte[] nonce) {
        return TestContext.builders().localServiceBuilderV2(nonce, PasetoV2ServiceTest.rfcLocalKeyProvider(), RfcToken.class).checkClaims(new Claim[0]).build();
    }

    private static TokenService<RfcToken> rfcPublicService() {
        return TestContext.builders().publicServiceBuilderV2(PasetoV2ServiceTest.rfcPublicKeyProvider(), RfcToken.class).checkClaims(new Claim[0]).build();
    }

    private static TokenService<Token> tokenLocalService(byte[] nonce) {
        return TestContext.builders().localServiceBuilderV2(nonce, PasetoV2ServiceTest.tokenLocalKeyProvider(), Token.class).checkClaims(new Claim[0]).build();
    }

    private static TokenService<Token> tokenPublicService() {
        return TestContext.builders().publicServiceBuilderV2(PasetoV2ServiceTest.tokenPublicKeyProvider(), Token.class).checkClaims(new Claim[0]).build();
    }

    @Test
    public void v2Service_localServiceBuilderRandomNonce() {
        LocalTokenService service = TestContext.builders().localServiceBuilderV2(null, PasetoV2ServiceTest.rfcLocalKeyProvider(), Token.class).build();
        Assert.assertNotNull((Object)service);
        Token token = new Token();
        token.setIssuedAt(OffsetDateTime.now().minusMinutes(10L));
        token.setExpiration(OffsetDateTime.now().plusMinutes(10L));
        String s = service.encode(token);
        Token token2 = service.decode(s);
        Assert.assertEquals((Object)token, (Object)token2);
    }

    @Test
    public void v2Service_publicServiceBuilderOverride() {
        PasetoV2.Builder pasetoBuilder = TestContext.builders().pasetoBuilderV2(null);
        PublicTokenService service = TestContext.builders().publicServiceBuilderV2(pasetoBuilder, PasetoV2ServiceTest.rfcPublicKeyProvider(), Token.class).build();
        Assert.assertNotNull((Object)service);
        Token token = new Token();
        token.setIssuedAt(OffsetDateTime.now().minusMinutes(10L));
        token.setExpiration(OffsetDateTime.now().plusMinutes(10L));
        String s = service.encode(token);
        Token token2 = service.decode(s);
        Assert.assertEquals((Object)token, (Object)token2);
    }

    @Test
    public void v2Service_rfcVectorE1() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_1;
        this.encodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE2() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_2;
        this.encodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE3() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_3;
        this.encodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE4() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_4;
        this.encodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE5() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_5;
        this.encodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE6() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_6;
        this.encodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE1Decrypt() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_1;
        this.decodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE2Decrypt() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_2;
        this.decodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE3Decrypt() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_3;
        this.decodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE4Decrypt() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_4;
        this.decodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE5Decrypt() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_5;
        this.decodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorE6Decrypt() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_E_6;
        this.decodeTestVector(PasetoV2ServiceTest.rfcLocalService(tv.getB()), tv);
    }

    @Test
    public void v2Service_rfcVectorS1Sign() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_S_1;
        this.encodeTestVector(PasetoV2ServiceTest.rfcPublicService(), tv);
    }

    @Test
    public void v2Service_rfcVectorS2Sign() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_S_2;
        this.encodeTestVector(PasetoV2ServiceTest.rfcPublicService(), tv);
    }

    @Test
    public void v2Service_rfcVectorS1Verify() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_S_1;
        this.decodeTestVector(PasetoV2ServiceTest.rfcPublicService(), tv);
    }

    @Test
    public void v2Service_rfcVectorS2Verify() {
        TestVector<RfcToken, KeyId> tv = RfcTestVectors.RFC_TEST_VECTOR_V2_S_2;
        this.decodeTestVector(PasetoV2ServiceTest.rfcPublicService(), tv);
    }

    @Test
    public void v2Service_local_decodeWithFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER;
        TokenService<Token> service = PasetoV2ServiceTest.tokenLocalService(tv.getB());
        TokenWithFooter result = service.decodeWithFooter(tv.getToken(), KeyId.class);
        Assert.assertEquals((Object)tv.getPayload(), (Object)result.getToken());
        Assert.assertEquals((Object)tv.getFooter(), (Object)result.getFooter());
    }

    @Test
    public void v2Service_public_decodeWithFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        TokenService<Token> service = PasetoV2ServiceTest.tokenPublicService();
        TokenWithFooter result = service.decodeWithFooter(tv.getToken(), KeyId.class);
        Assert.assertEquals((Object)tv.getPayload(), (Object)result.getToken());
        Assert.assertEquals((Object)tv.getFooter(), (Object)result.getFooter());
    }

    @Test
    public void v2Service_local_extractFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER;
        TokenService<Token> service = PasetoV2ServiceTest.tokenLocalService(tv.getB());
        KeyId result = (KeyId)service.getFooter(tv.getToken(), KeyId.class);
        Assert.assertEquals((Object)tv.getFooter(), (Object)result);
    }

    @Test
    public void v2Service_local_extractFooter_asString() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER;
        TokenService<Token> service = PasetoV2ServiceTest.tokenLocalService(tv.getB());
        String result = service.getFooter(tv.getToken());
        Assert.assertEquals((Object)"{\"kid\":\"key-1\"}", (Object)result);
    }

    @Test
    public void v2Service_public_extractFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        TokenService<Token> service = PasetoV2ServiceTest.tokenPublicService();
        KeyId result = (KeyId)service.getFooter(tv.getToken(), KeyId.class);
        Assert.assertEquals((Object)tv.getFooter(), (Object)result);
    }

    @Test
    public void v2Service_public_extractFooter_asString() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        TokenService<Token> service = PasetoV2ServiceTest.tokenPublicService();
        String result = service.getFooter(tv.getToken());
        Assert.assertEquals((Object)"{\"kid\":\"key-1\"}", (Object)result);
    }

    @Test
    public void v2Service_local_defaultValidityPeriod() {
        Token token = new Token().setTokenId("id");
        LocalTokenService service = TestContext.builders().localServiceBuilderV2(null, PasetoV2ServiceTest.rfcLocalKeyProvider(), Token.class).withDefaultValidityPeriod(Duration.ofMinutes(5L)).build();
        String s = service.encode(token);
        Token token2 = service.decode(s);
        Assert.assertNotNull((Object)token2.getIssuedAt());
        Assert.assertNotNull((Object)token2.getExpiration());
    }

    @Test(expected=MissingClaimException.class)
    public void v2Service_local_noExpiry() {
        Token token = new Token().setTokenId("id");
        LocalTokenService service = TestContext.builders().localServiceBuilderV2(null, PasetoV2ServiceTest.rfcLocalKeyProvider(), Token.class).build();
        AssertUtils.assertMissingClaimException(() -> service.encode(token), "TokenService", token, "EXPIRATION");
    }

    @Test
    public void v2Service_public_defaultValidityPeriod() {
        Token token = new Token().setTokenId("id");
        PublicTokenService service = TestContext.builders().publicServiceBuilderV2(PasetoV2ServiceTest.rfcPublicKeyProvider(), Token.class).withDefaultValidityPeriod(Duration.ofMinutes(5L)).build();
        String s = service.encode(token);
        Token token2 = service.decode(s);
        Assert.assertNotNull((Object)token2.getIssuedAt());
        Assert.assertNotNull((Object)token2.getExpiration());
    }

    @Test(expected=MissingClaimException.class)
    public void v2Service_public_noExpiry() {
        Token token = new Token().setTokenId("id");
        PublicTokenService service = TestContext.builders().publicServiceBuilderV2(PasetoV2ServiceTest.rfcPublicKeyProvider(), Token.class).build();
        AssertUtils.assertMissingClaimException(() -> service.encode(token), "TokenService", token, "EXPIRATION");
    }

    @Test
    public void v2Service_local_ctors1() {
        PasetoV2 paseto = TestContext.builders().pasetoBuilderV2(null).build();
        LocalTokenService service = new LocalTokenService.Builder((Paseto)paseto, Token.class, PasetoV2ServiceTest.rfcLocalKeyProvider()).build();
        this.checkDefault((TokenService<Token>)service);
    }

    @Test
    public void v2Service_local_ctors2() {
        PasetoV2 paseto = TestContext.builders().pasetoBuilderV2(null).build();
        LocalTokenService service = new LocalTokenService.Builder((Paseto)paseto, Token.class, PasetoV2ServiceTest.rfcLocalKeyProvider()).checkClaims(new Claim[]{new CurrentlyValid()}).build();
        this.checkOnlyCurrentlyValid((TokenService<Token>)service);
    }

    @Test
    public void v2Service_local_ctors3() {
        PasetoV2 paseto = TestContext.builders().pasetoBuilderV2(null).build();
        LocalTokenService service = new LocalTokenService.Builder((Paseto)paseto, Token.class, PasetoV2ServiceTest.rfcLocalKeyProvider()).withDefaultValidityPeriod(Duration.ofMinutes(5L)).build();
        this.checkDefaultWithValidity((TokenService<Token>)service);
    }

    @Test
    public void v2Service_local_ctors4() {
        PasetoV2 paseto = TestContext.builders().pasetoBuilderV2(null).build();
        LocalTokenService service = new LocalTokenService.Builder((Paseto)paseto, Token.class, PasetoV2ServiceTest.rfcLocalKeyProvider()).withDefaultValidityPeriod(Duration.ofMinutes(5L)).checkClaims(new Claim[]{new CurrentlyValid()}).build();
        this.checkOnlyCurrentlyVaildWithValidity((TokenService<Token>)service);
    }

    @Test
    public void v2Service_public_ctors1() {
        PasetoV2 paseto = TestContext.builders().pasetoBuilderV2(null).build();
        PublicTokenService service = new PublicTokenService.Builder((Paseto)paseto, Token.class, PasetoV2ServiceTest.rfcPublicKeyProvider()).build();
        this.checkDefault((TokenService<Token>)service);
    }

    @Test
    public void v2Service_public_ctors2() {
        PasetoV2 paseto = TestContext.builders().pasetoBuilderV2(null).build();
        PublicTokenService service = new PublicTokenService.Builder((Paseto)paseto, Token.class, PasetoV2ServiceTest.rfcPublicKeyProvider()).checkClaims(new Claim[]{new CurrentlyValid()}).build();
        this.checkOnlyCurrentlyValid((TokenService<Token>)service);
    }

    @Test
    public void v2Service_public_ctors3() {
        PasetoV2 paseto = TestContext.builders().pasetoBuilderV2(null).build();
        PublicTokenService service = new PublicTokenService.Builder((Paseto)paseto, Token.class, PasetoV2ServiceTest.rfcPublicKeyProvider()).withDefaultValidityPeriod(Duration.ofMinutes(5L)).build();
        this.checkDefaultWithValidity((TokenService<Token>)service);
    }

    @Test
    public void v2Service_public_ctors4() {
        PasetoV2 paseto = TestContext.builders().pasetoBuilderV2(null).build();
        PublicTokenService service = new PublicTokenService.Builder((Paseto)paseto, Token.class, PasetoV2ServiceTest.rfcPublicKeyProvider()).withDefaultValidityPeriod(Duration.ofMinutes(5L)).checkClaims(new Claim[]{new CurrentlyValid()}).build();
        this.checkOnlyCurrentlyVaildWithValidity((TokenService<Token>)service);
    }
}

