/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test.utils;

import java.util.function.Consumer;
import net.aholbrook.paseto.crypto.exception.ByteArrayLengthException;
import net.aholbrook.paseto.crypto.exception.ByteArrayRangeException;
import net.aholbrook.paseto.exception.InvalidFooterException;
import net.aholbrook.paseto.exception.InvalidHeaderException;
import net.aholbrook.paseto.exception.PasetoParseException;
import net.aholbrook.paseto.exception.PasetoStringException;
import net.aholbrook.paseto.exception.claims.ClaimException;
import net.aholbrook.paseto.exception.claims.MissingClaimException;
import net.aholbrook.paseto.exception.claims.MultipleClaimException;
import net.aholbrook.paseto.service.Token;
import org.junit.Assert;

public class AssertUtils {
    public static void assertEquals(byte[] expected, byte[] actual) {
        Assert.assertNotNull((String)"result not null", (Object)actual);
        Assert.assertEquals((String)"result length", (long)expected.length, (long)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            Assert.assertEquals((String)("array index " + Integer.toString(i)), (long)expected[i], (long)actual[i]);
        }
    }

    public static void assertEquals(short[] expected, byte[] actual) {
        Assert.assertNotNull((String)"result not null", (Object)actual);
        Assert.assertEquals((String)"result length", (long)expected.length, (long)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            Assert.assertEquals((String)("array index " + Integer.toString(i)), (long)((byte)expected[i]), (long)actual[i]);
        }
    }

    public static void assertNotEquals(byte[] expected, byte[] actual) {
        Assert.assertNotNull((String)"result not null", (Object)actual);
        Assert.assertEquals((String)"result length", (long)expected.length, (long)actual.length);
        boolean match = true;
        for (int i = 0; i < actual.length; ++i) {
            if (expected[i] == actual[i]) continue;
            match = false;
        }
        Assert.assertFalse((String)"arrays match", (boolean)match);
    }

    public static void assertByteArrayRangeException(Runnable r, String arg, int len, int lower, int upper) {
        try {
            r.run();
        }
        catch (ByteArrayRangeException e) {
            Assert.assertEquals((String)"arg", (Object)arg, (Object)e.getArg());
            Assert.assertEquals((String)"len", (long)len, (long)e.getLen());
            Assert.assertEquals((String)"minBound", (long)lower, (long)e.getMinBound());
            Assert.assertEquals((String)"maxBound", (long)upper, (long)e.getMaxBound());
            throw e;
        }
    }

    public static void assertByteArrayLengthException(Runnable r, String arg, int len, int required, boolean exact) {
        try {
            r.run();
        }
        catch (ByteArrayLengthException e) {
            Assert.assertEquals((Object)arg, (Object)e.getArg());
            Assert.assertEquals((long)len, (long)e.getLen());
            Assert.assertEquals((long)required, (long)e.getRequired());
            Assert.assertEquals((Object)exact, (Object)e.isExact());
            throw e;
        }
    }

    public static void assertInvalidHeaderException(Runnable r, String given, String expected) {
        try {
            r.run();
        }
        catch (InvalidHeaderException e) {
            Assert.assertEquals((String)"given", (Object)given, (Object)e.getGiven());
            Assert.assertEquals((String)"expected", (Object)expected, (Object)e.getExpected());
            throw e;
        }
    }

    public static void assertInvalidFooterException(Runnable r, String given, String expected) {
        try {
            r.run();
        }
        catch (InvalidFooterException e) {
            Assert.assertEquals((String)"given", (Object)given, (Object)e.getGiven());
            Assert.assertEquals((String)"expected", (Object)expected, (Object)e.getExpected());
            throw e;
        }
    }

    public static void assertPasetoStringException(Runnable r, String token) {
        try {
            r.run();
        }
        catch (PasetoStringException e) {
            Assert.assertEquals((String)"token", (Object)token, (Object)e.getToken());
            throw e;
        }
    }

    public static void assertClaimException(Runnable r, Consumer<ClaimException> assertRunner, String rule, Token token) {
        try {
            r.run();
        }
        catch (ClaimException e) {
            if (assertRunner != null) {
                assertRunner.accept(e);
            }
            Assert.assertEquals((String)"rule name", (Object)rule, (Object)e.getRuleName());
            Assert.assertEquals((String)"token", (Object)token, (Object)e.getToken());
            throw e;
        }
    }

    public static void assertMissingClaimException(Runnable r, String rule, Token token, String claim) {
        try {
            r.run();
        }
        catch (MissingClaimException e) {
            Assert.assertEquals((String)"rule name", (Object)rule, (Object)e.getRuleName());
            Assert.assertEquals((String)"token", (Object)token, (Object)e.getToken());
            Assert.assertEquals((String)"claim", (Object)claim, (Object)e.getClaim());
            throw e;
        }
    }

    public static void assertMultiClaimException(Runnable r, Class[] classes) {
        try {
            r.run();
        }
        catch (MultipleClaimException e) {
            Assert.assertEquals((String)"count", (long)e.getExceptions().size(), (long)2L);
            for (int i = 0; i < classes.length; ++i) {
                Assert.assertEquals((String)("index: " + Integer.toString(i)), ((Object)((Object)((ClaimException)((Object)e.getExceptions().get(i))))).getClass(), (Object)classes[i]);
            }
            throw e;
        }
    }

    public static <_Token> void assertPasetoParseException(Runnable r, _Token token, PasetoParseException.Reason reason, int minLength) {
        try {
            r.run();
        }
        catch (PasetoParseException e) {
            Assert.assertEquals(token, (Object)e.getToken());
            Assert.assertEquals((Object)reason, (Object)e.getReason());
            Assert.assertEquals((long)minLength, (long)e.getMinLength());
            throw e;
        }
    }
}

