/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import java.nio.charset.Charset;
import net.aholbrook.paseto.Paseto;
import net.aholbrook.paseto.test.data.TestVector;
import net.aholbrook.paseto.util.StringUtils;
import org.junit.Assert;

public abstract class PasetoTest {
    protected abstract Paseto createPaseto(byte[] var1);

    protected <_TokenType, _Footer> void encryptTestVector(TestVector<_TokenType, _Footer> tv) {
        Paseto paseto = this.createPaseto(tv.getB());
        Assert.assertNotNull((String)"paseto V1 instance", (Object)paseto);
        String token = tv.getFooter() != null ? paseto.encrypt(tv.getPayload(), tv.getA(), tv.getFooter()) : paseto.encrypt(tv.getPayload(), tv.getA());
        Assert.assertEquals((String)"Generated token does not match test vector.", (Object)tv.getToken(), (Object)token);
    }

    protected <_TokenType, _Footer> void decryptTestVector(TestVector<_TokenType, _Footer> tv) {
        Paseto paseto = this.createPaseto(tv.getB());
        Assert.assertNotNull((String)"paseto V1 instance", (Object)paseto);
        Object payload = tv.getFooter() != null ? paseto.decrypt(tv.getToken(), tv.getA(), tv.getFooter(), tv.getPayloadClass()) : paseto.decrypt(tv.getToken(), tv.getA(), tv.getPayloadClass());
        Assert.assertEquals((String)"Decrypted payload does not match test vector.", tv.getPayload(), (Object)payload);
    }

    protected <_TokenType, _Footer> void signTestVector(TestVector<_TokenType, _Footer> tv, boolean assertSigned) {
        Paseto paseto = this.createPaseto(null);
        Assert.assertNotNull((String)"paseto V1 instance", (Object)paseto);
        String token = tv.getFooter() != null ? paseto.sign(tv.getPayload(), tv.getA(), tv.getFooter()) : paseto.sign(tv.getPayload(), tv.getA());
        if (assertSigned) {
            Assert.assertEquals((String)"Generated token does not match test vector.", (Object)tv.getToken(), (Object)token);
        }
        Object decoded = tv.getFooter() != null ? paseto.verify(token, tv.getB(), tv.getFooter(), tv.getPayloadClass()) : paseto.verify(token, tv.getB(), tv.getPayloadClass());
        Assert.assertEquals((String)"Decoded payload does not match test vector.", tv.getPayload(), (Object)decoded);
    }

    protected <_TokenType, _Footer> void verifyTestVector(TestVector<_TokenType, _Footer> tv) {
        Paseto paseto = this.createPaseto(null);
        Assert.assertNotNull((String)"paseto V1 instance", (Object)paseto);
        Object payload = tv.getFooter() != null ? paseto.verify(tv.getToken(), tv.getB(), tv.getFooter(), tv.getPayloadClass()) : paseto.verify(tv.getToken(), tv.getB(), tv.getPayloadClass());
        Assert.assertEquals((String)"Verified payload does not match test vector.", tv.getPayload(), (Object)payload);
    }

    protected String modify(String token, int[] indices) {
        byte[] tokenBytes = StringUtils.getBytesUtf8((String)token);
        int[] nArray = indices;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int i2;
            int n2 = i2 = nArray[i];
            tokenBytes[n2] = (byte)(tokenBytes[n2] ^ 1);
        }
        return new String(tokenBytes, Charset.forName("UTF-8"));
    }
}

